// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./commerce/shopping_list.js";import"./icons.html.js";import"./power_bookmarks_context_menu.js";import"./power_bookmarks_labels.js";import"./power_bookmark_row.js";import"./power_bookmarks_context_menu.js";import"./power_bookmarks_edit_dialog.js";import"//bookmarks-side-panel.top-chrome/shared/sp_empty_state.js";import"//bookmarks-side-panel.top-chrome/shared/sp_footer.js";import"//bookmarks-side-panel.top-chrome/shared/sp_heading.js";import"//bookmarks-side-panel.top-chrome/shared/sp_icons.html.js";import"//bookmarks-side-panel.top-chrome/shared/sp_list_item_badge.js";import"//bookmarks-side-panel.top-chrome/shared/sp_shared_style.css.js";import"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_dialog/cr_dialog.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/cr_lazy_render/cr_lazy_render.js";import"//resources/cr_elements/cr_toast/cr_toast.js";import"//resources/cr_elements/cr_toolbar/cr_toolbar_search_field.js";import"//resources/cr_elements/cr_toolbar/cr_toolbar_selection_overlay.js";import"//resources/cr_elements/icons.html.js";import"//resources/polymer/v3_0/iron-list/iron-list.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{PriceTrackingBrowserProxyImpl}from"//resources/cr_components/commerce/price_tracking_browser_proxy.js";import{getInstance as getAnnouncerInstance}from"//resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{FocusOutlineManager}from"//resources/js/focus_outline_manager.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PluralStringProxyImpl}from"//resources/js/plural_string_proxy.js";import{listenOnce}from"//resources/js/util.js";import{afterNextRender,Debouncer,PolymerElement,timeOut}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ActionSource,SortOrder,ViewType}from"./bookmarks.mojom-webui.js";import{BookmarksApiProxyImpl}from"./bookmarks_api_proxy.js";import{KeyArrowNavigationService}from"./keyboard_arrow_navigation_service.js";import{BOOKMARK_ROW_LOAD_EVENT}from"./power_bookmark_row.js";import{PowerBookmarksDragManager}from"./power_bookmarks_drag_manager.js";import{TEMP_FOLDER_ID_PREFIX}from"./power_bookmarks_edit_dialog.js";import{getTemplate}from"./power_bookmarks_list.html.js";import{editingDisabledByPolicy,PowerBookmarksService}from"./power_bookmarks_service.js";import{getFolderLabel}from"./power_bookmarks_utils.js";const ADD_FOLDER_ACTION_UMA="Bookmarks.FolderAddedFromSidePanel";const ADD_URL_ACTION_UMA="Bookmarks.AddedFromSidePanel";function getBookmarkName(bookmark){return bookmark.title||bookmark.url||""}export var SearchAction;(function(SearchAction){SearchAction[SearchAction["SHOWN"]=0]="SHOWN";SearchAction[SearchAction["SEARCHED"]=1]="SEARCHED";SearchAction[SearchAction["COUNT"]=2]="COUNT"})(SearchAction||(SearchAction={}));export class PowerBookmarksListElement extends PolymerElement{static get is(){return"power-bookmarks-list"}static get template(){return getTemplate()}static get properties(){return{displayLists_:{type:Array,value:()=>[]},compact_:{type:Boolean,value:()=>loadTimeData.getInteger("viewType")===0,observer:"updateListScrollOffset_"},contextMenuBookmark_:Object,activeFolderPath_:{type:Array,value:()=>[]},currentUrl_:String,imageUrls_:{type:Object,value:()=>({})},labels_:{type:Array,value:()=>[]},activeSortIndex_:{type:Number,value:()=>loadTimeData.getInteger("sortOrder")},sortTypes_:{type:Array,value:()=>[{sortOrder:SortOrder.kNewest,label:loadTimeData.getString("sortNewest"),lowerLabel:loadTimeData.getString("sortNewestLower")},{sortOrder:SortOrder.kOldest,label:loadTimeData.getString("sortOldest"),lowerLabel:loadTimeData.getString("sortOldestLower")},{sortOrder:SortOrder.kLastOpened,label:loadTimeData.getString("sortLastOpened"),lowerLabel:loadTimeData.getString("sortLastOpenedLower")},{sortOrder:SortOrder.kAlphabetical,label:loadTimeData.getString("sortAlphabetically"),lowerLabel:loadTimeData.getString("sortAlphabetically")},{sortOrder:SortOrder.kReverseAlphabetical,label:loadTimeData.getString("sortReverseAlphabetically"),lowerLabel:loadTimeData.getString("sortReverseAlphabetically")}]},editing_:{type:Boolean,value:false},selectedBookmarks_:{type:Object,value:()=>({})},guestMode_:{type:Boolean,value:loadTimeData.getBoolean("guestMode"),reflectToAttribute:true},renamingId_:{type:String,value:""},bookmarksTreeViewEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("bookmarksTreeViewEnabled")},deletionDescription_:{type:String,value:""},hasScrollbars_:{type:Boolean,value:false,reflectToAttribute:true},hasLoadedData_:{type:Boolean,value:false},searchQuery_:String,shoppingCollectionFolderId_:String,trackedProductInfos_:{type:Object,value:()=>({})},updatedElementIds_:{type:Array,value:()=>[]},hasSomeActiveFilter_:{type:Boolean,value:false,computed:"computeHasSomeActiveFilter_(searchQuery_, labels_.*)"},hasShownBookmarks_:{type:Boolean,value:false,computed:"computeHasShownBookmarks_(displayLists_.*)"},canDrag_:{type:Boolean,value:true,computed:"computeCanDrag_(editing_, renamingId_, hasSomeActiveFilter_)",observer:"onCanDragChange_"},hasActiveDrag_:{type:Boolean,value:false},sectionVisibility_:{type:Object,computed:"computeSectionVisibility_(hasLoadedData_,"+"activeFolderPath_.length, hasShownBookmarks_,"+"labels_.length, hasSomeActiveFilter_)"},hasFolders_:{type:Boolean,computed:"computeHasFolders_(displayLists_.*)",reflect:true}}}static get observers(){return["updateDisplayLists_(activeFolderPath_.splices, labels_.*, "+"activeSortIndex_, searchQuery_)"]}bookmarksApi_=BookmarksApiProxyImpl.getInstance();priceTrackingProxy_=PriceTrackingBrowserProxyImpl.getInstance();shoppingListenerIds_=[];availableProductInfos_=new Map;bookmarksService_;keyArrowNavigationService_;bookmarksDragManager_;focusOutlineManager_;shownBookmarksResizeObserver_;recordCountMetricsOnNextUpdate_=false;isBookmarksInTransportModeEnabled=loadTimeData.getBoolean("isBookmarksInTransportModeEnabled");rebuildNavigationElementsDebouncer_=null;constructor(){super();ColorChangeUpdater.forDocument().start();const bookmarksService=new PowerBookmarksService(this);PowerBookmarksService.setInstance(bookmarksService);this.bookmarksService_=PowerBookmarksService.getInstance();const keyArrowNavigationService=new KeyArrowNavigationService(this,"power-bookmark-row:not([hidden])");KeyArrowNavigationService.setInstance(keyArrowNavigationService);this.keyArrowNavigationService_=KeyArrowNavigationService.getInstance();this.bookmarksDragManager_=new PowerBookmarksDragManager(this)}connectedCallback(){super.connectedCallback();this.setAttribute("role","application");listenOnce(this.$.powerBookmarksContainer,"dom-change",(()=>{setTimeout((()=>this.bookmarksApi_.showUi()),0)}));this.focusOutlineManager_=FocusOutlineManager.forDocument(document);this.bookmarksService_.startListening();this.priceTrackingProxy_.getAllPriceTrackedBookmarkProductInfo().then((res=>{res.productInfos.forEach((product=>this.set(`trackedProductInfos_.${product.bookmarkId.toString()}`,product)))}));this.priceTrackingProxy_.getAllShoppingBookmarkProductInfo().then((res=>{res.productInfos.forEach((product=>this.setAvailableProductInfo_(product)))}));this.updateShoppingCollectionFolderId_();const callbackRouter=this.priceTrackingProxy_.getCallbackRouter();this.shoppingListenerIds_.push(callbackRouter.priceTrackedForBookmark.addListener((product=>this.onBookmarkPriceTracked_(product))),callbackRouter.priceUntrackedForBookmark.addListener((product=>this.onBookmarkPriceUntracked_(product))));this.shownBookmarksResizeObserver_=new ResizeObserver(this.onShownBookmarksResize_.bind(this));this.shownBookmarksResizeObserver_.observe(this.$.bookmarks);this.updateListScrollOffset_();this.bookmarksDragManager_.startObserving();this.recordMetricsOnConnected_();this.keyArrowNavigationService_.startListening();this.addEventListener(BOOKMARK_ROW_LOAD_EVENT,(()=>{this.rebuildNavigationElementsDebouncer_=Debouncer.debounce(this.rebuildNavigationElementsDebouncer_,timeOut.after(1),(()=>{this.keyArrowNavigationService_.rebuildNavigationElements()}))}))}disconnectedCallback(){this.bookmarksService_.stopListening();this.shoppingListenerIds_.forEach((id=>this.priceTrackingProxy_.getCallbackRouter().removeListener(id)));this.shownBookmarksResizeObserver_.disconnect();this.shownBookmarksResizeObserver_=undefined;this.bookmarksDragManager_.stopObserving();this.keyArrowNavigationService_.stopListening()}setCurrentUrl(url){this.currentUrl_=url}getCurrentUrlForTesting(){return this.currentUrl_}setImageUrl(bookmark,url){this.set(`imageUrls_.${bookmark.id.toString()}`,url);this.imageUrls_=structuredClone(this.imageUrls_)}onBookmarksLoaded(){this.updateDisplayLists_();this.hasLoadedData_=true}onBookmarkChanged(id){const bookmark=this.bookmarksService_.findBookmarkWithId(id);this.updatedElementIds_=[bookmark.id];if(this.bookmarkShouldShow_(bookmark)||this.bookmarkIsShowing_(bookmark)){this.updateDisplayLists_()}this.notifyPathIfVisible_(id,"title");this.notifyPathIfVisible_(id,"url");this.updateShoppingData_()}onBookmarkAdded(bookmark,parent){if(this.bookmarkShouldShow_(bookmark)){this.updateShoppingCollectionFolderId_();const scrollTop=this.$.bookmarks.scrollTop;this.updateDisplayLists_();if(bookmark.url){getAnnouncerInstance().announce(loadTimeData.getStringF("bookmarkCreated",getBookmarkName(bookmark)))}else{getAnnouncerInstance().announce(loadTimeData.getStringF("bookmarkFolderCreated",getBookmarkName(bookmark)))}for(let i=0;i<this.displayLists_.length;i++){const indexInList=this.displayLists_[i].indexOf(bookmark);if(indexInList>-1){const listElement=this.getDisplayListElement_(i);if(listElement&&(indexInList<listElement.firstVisibleIndex||indexInList>listElement.lastVisibleIndex)){listElement.scrollToIndex(indexInList)}else{afterNextRender(this,(()=>{this.$.bookmarks.scrollTop=scrollTop}))}break}}}this.updatedElementIds_=[bookmark.id];this.updateShoppingData_();this.notifyPathIfVisible_(parent.id,"children")}onBookmarkMoved(bookmark,oldParent,newParent){const shouldShow=this.bookmarkShouldShow_(bookmark);const isShowing=this.bookmarkIsShowing_(bookmark);if(oldParent===newParent&&shouldShow){getAnnouncerInstance().announce(loadTimeData.getStringF("bookmarkReordered",getBookmarkName(bookmark)))}else if(shouldShow!==isShowing||shouldShow&&this.hasSomeActiveFilter_){const scrollTop=this.$.bookmarks.scrollTop;this.updateDisplayLists_();getAnnouncerInstance().announce(loadTimeData.getStringF("bookmarkMoved",getBookmarkName(bookmark),getBookmarkName(newParent)));afterNextRender(this,(()=>{this.$.bookmarks.scrollTop=scrollTop}))}this.updatedElementIds_=[newParent.id,oldParent.id];this.notifyPathIfVisible_(newParent.id,"children");if(this.bookmarksTreeViewEnabled_&&this.compact_){this.notifyBookmarksListResize_()}}onBookmarkRemoved(bookmark){const scrollTop=this.$.bookmarks.scrollTop;this.updateDisplayLists_();const isShown=this.bookmarkIsShowing_(bookmark);if(isShown){this.removeNodeFromDisplayLists_(bookmark.id);getAnnouncerInstance().announce(loadTimeData.getStringF("bookmarkDeleted",getBookmarkName(bookmark)));afterNextRender(this,(()=>{this.$.bookmarks.scrollTop=scrollTop}))}if(this.shoppingCollectionFolderId_===bookmark.id){this.shoppingCollectionFolderId_=""}this.updatedElementIds_=[bookmark.parentId];this.set(`trackedProductInfos_.${bookmark.id}`,null);this.availableProductInfos_.delete(bookmark.id);this.notifyPathIfVisible_(bookmark.parentId,"children");afterNextRender(this,(()=>{this.keyArrowNavigationService_.rebuildNavigationElements()}))}getTrackedProductInfos(){return this.trackedProductInfos_}getAvailableProductInfos(){return this.availableProductInfos_}getProductImageUrl(bookmark){const bookmarkProductInfo=this.availableProductInfos_.get(bookmark.id);if(bookmarkProductInfo){return bookmarkProductInfo.info.imageUrl.url}else{return""}}getFallbackBookmark(){if(this.bookmarksTreeViewEnabled_&&this.compact_){return this.bookmarksService_.findBookmarkWithId(loadTimeData.getString("otherBookmarksId"))}return this.getParentFolder_()}getFallbackDropTargetElement(){return this}onFinishDrop(dropTarget){this.updateDisplayLists_();this.focusBookmark_(dropTarget.id);this.focusOutlineManager_.visible=true;document.addEventListener("mousedown",(()=>{this.focusOutlineManager_.visible=false}),{once:true})}setHasActiveDrag(hasActiveDrag){this.hasActiveDrag_=hasActiveDrag}clickBookmarkRowForTests(bookmark){const event=new CustomEvent("row-clicked",{bubbles:true,composed:true,detail:{bookmark:bookmark,event:new MouseEvent("row-clicked")}});this.onRowClicked_(event)}setRenamingIdForTests(id){const event=new CustomEvent("rename",{bubbles:true,composed:true,detail:{id:id}});this.setRenamingId_(event)}getKeyboardNavigationServiceforTesting(){return this.keyArrowNavigationService_}getDragManagerForTesting(){return this.bookmarksDragManager_}notifyPathIfVisible_(id,key){for(let i=0;i<this.displayLists_.length;i++){const listIndex=this.displayLists_[i].findIndex((b=>b.id===id));if(listIndex>-1){this.notifyPath(`displayLists_.${i}.${listIndex}.${key}`);return}}}computeHasFolders_(){if(!this.displayLists_||this.displayLists_.length===0){return false}return this.displayLists_.some((list=>list.some((bookmark=>!!bookmark.children))))}computeCanDrag_(){return!this.editing_&&!this.renamingId_&&!this.hasSomeActiveFilter_}focusBookmark_(id){const bookmarkElement=this.shadowRoot.querySelector(`#bookmark-${id}`);if(bookmarkElement){bookmarkElement.focus()}}onBookmarkPriceTracked_(product){this.set(`trackedProductInfos_.${product.bookmarkId.toString()}`,product)}onBookmarkPriceUntracked_(product){this.set(`trackedProductInfos_.${product.bookmarkId.toString()}`,null)}bookmarkIsShowing_(bookmark){return this.displayLists_.some((list=>list.some((item=>item.id===bookmark.id))))}removeNodeFromDisplayLists_(nodeId){for(let listIndex=0;listIndex<this.displayLists_.length;listIndex++){const itemIndex=this.displayLists_[listIndex].findIndex((b=>b.id===nodeId));if(itemIndex>-1){this.splice(`displayLists_.${listIndex}`,itemIndex,1)}}}visibleParent_(parent){const activeFolder=this.getActiveFolder_();return!activeFolder&&parent.parentId===loadTimeData.getString("rootBookmarkId")&&!this.bookmarkIsShowing_(parent)||parent===activeFolder}bookmarkShouldShow_(bookmark){if(this.hasSomeActiveFilter_){return this.bookmarksService_.bookmarkMatchesSearchQueryAndLabels(bookmark,this.labels_,this.searchQuery_)}return this.visibleParent_(this.bookmarksService_.findBookmarkWithId(bookmark.parentId))}getActiveFolder_(){if(this.activeFolderPath_.length){return this.activeFolderPath_[this.activeFolderPath_.length-1]}return undefined}getBackButtonLabel_(){const activeFolder=this.getActiveFolder_();const parentFolder=this.bookmarksService_.findBookmarkWithId(activeFolder?activeFolder.parentId:undefined);return loadTimeData.getStringF("backButtonLabel",getFolderLabel(parentFolder))}getBookmarksListRole_(){return this.editing_?"listbox":"list"}getViewButtonIcon_(){return this.compact_?"bookmarks:compact-view":"bookmarks:visual-view"}getViewButtonTooltip_(){return this.compact_?loadTimeData.getString("compactView"):loadTimeData.getString("visualView")}updateShoppingCollectionFolderId_(){this.priceTrackingProxy_.getShoppingCollectionBookmarkFolderId().then((res=>{this.shoppingCollectionFolderId_=res.collectionId.toString()}))}getActiveFolderLabel_(){return getFolderLabel(this.getActiveFolder_())}getSortLabel_(){return this.sortTypes_[this.activeSortIndex_].label}updateShoppingData_(){this.availableProductInfos_.clear();this.priceTrackingProxy_.getAllShoppingBookmarkProductInfo().then((res=>{res.productInfos.forEach((product=>this.setAvailableProductInfo_(product)))}))}setAvailableProductInfo_(productInfo){const bookmarkId=productInfo.bookmarkId.toString();this.availableProductInfos_.set(bookmarkId,productInfo);if(productInfo.info.imageUrl.url===""){return}const bookmark=this.bookmarksService_.findBookmarkWithId(bookmarkId);if(!bookmark){return}this.setImageUrl(bookmark,productInfo.info.imageUrl.url)}updateDisplayLists_(){const activeFolder=this.getActiveFolder_();const primaryList=this.bookmarksService_.filterBookmarks(activeFolder,this.activeSortIndex_,this.searchQuery_,this.labels_);if(this.hasSomeActiveFilter_&&!!activeFolder){const secondaryList=this.bookmarksService_.filterBookmarks(undefined,this.activeSortIndex_,this.searchQuery_,this.labels_,activeFolder);this.displayLists_=[primaryList,secondaryList]}else{this.displayLists_=[primaryList]}this.displayLists_.forEach((list=>this.bookmarksService_.refreshDataForBookmarks(list)));this.updateListScrollOffset_();if(this.recordCountMetricsOnNextUpdate_){this.recordBookmarkCountMetrics_();this.recordCountMetricsOnNextUpdate_=false}afterNextRender(this,(()=>{const children=[...this.shadowRoot.querySelectorAll("power-bookmark-row")];if(children.length>0){Promise.all(children.map((el=>el.updateComplete))).then((()=>{this.notifyBookmarksListResize_();this.keyArrowNavigationService_.rebuildNavigationElements()}))}}))}updateListScrollOffset_(){afterNextRender(this,(()=>{const primaryList=this.getDisplayListElement_(0);const secondaryList=this.getDisplayListElement_(1);const bookmarksOffsetTop=this.$.bookmarks.offsetTop;if(primaryList){primaryList.scrollOffset=primaryList.offsetTop-bookmarksOffsetTop}if(secondaryList){secondaryList.scrollOffset=secondaryList.offsetTop-bookmarksOffsetTop}}))}onCanDragChange_(){if(this.canDrag_){this.bookmarksDragManager_.startObserving()}else{this.bookmarksDragManager_.stopObserving()}}recordMetricsOnConnected_(){chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.SortTypeShown",this.sortTypes_[this.activeSortIndex_].sortOrder,SortOrder.kCount);chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.ViewTypeShown",this.compact_?ViewType.kCompact:ViewType.kExpanded,ViewType.kCount);chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.Search.CTR",SearchAction.SHOWN,SearchAction.COUNT);this.recordCountMetricsOnNextUpdate_=true}recordBookmarkCountMetrics_(){const count=this.bookmarksTreeViewEnabled_?this.keyArrowNavigationService_.getElementCount():this.displayLists_.reduce(((prev,curr)=>prev+curr.length),0);const metricName=`PowerBookmarks.SidePanel${this.hasSomeActiveFilter_?".SearchOrFilter":""}.BookmarksShown`;chrome.metricsPrivate.recordMediumCount(metricName,count)}canAddCurrentUrl_(){return this.bookmarksService_.canAddUrl(this.currentUrl_,this.getActiveFolder_())}getSortMenuItemLabel_(sortType){return loadTimeData.getStringF("sortByType",sortType.label)}getSortMenuItemLowerLabel_(sortType){return loadTimeData.getStringF("sortByType",sortType.lowerLabel)}sortMenuItemIsSelected_(sortType){return this.sortTypes_[this.activeSortIndex_].sortOrder===sortType.sortOrder}onRowToggled_(_event){this.notifyBookmarksListResize_();afterNextRender(this,(()=>this.recordBookmarkCountMetrics_()))}onRowClicked_(event){event.preventDefault();event.stopPropagation();if(!this.editing_){if(event.detail.bookmark.children){this.recordCountMetricsOnNextUpdate_=true;this.push("activeFolderPath_",event.detail.bookmark);this.$.searchField.setValue("");afterNextRender(this,(()=>{for(let i=0;i<this.displayLists_.length;i++){if(this.displayLists_[i].length>0){this.getDisplayListElement_(i).focusItem(0);break}}}))}else{this.bookmarksApi_.openBookmark(event.detail.bookmark.id,this.activeFolderPath_.length,{middleButton:event.detail.event.button===1,altKey:event.detail.event.altKey,ctrlKey:event.detail.event.ctrlKey,metaKey:event.detail.event.metaKey,shiftKey:event.detail.event.shiftKey},ActionSource.kBookmark)}}if(event.target){event.target.blur()}}onRowSelectedChange_(event){event.preventDefault();event.stopPropagation();const isSelected=Object.entries(this.selectedBookmarks_).find((([key,_val])=>key===event.detail.bookmark.id))?.[1]??false;if(event.detail.checked&&!isSelected){this.set(`selectedBookmarks_.${event.detail.bookmark.id.toString()}`,true)}else if(!event.detail.checked&&isSelected){this.set(`selectedBookmarks_.${event.detail.bookmark.id.toString()}`,false)}}async onBookmarksEdited_(event){event.preventDefault();event.stopPropagation();let parentId=event.detail.folderId;for(const folder of event.detail.newFolders){chrome.metricsPrivate.recordUserAction(ADD_FOLDER_ACTION_UMA);const result=await this.bookmarksApi_.createFolder(folder.parentId,folder.title);folder.children.forEach((child=>child.parentId=result.newFolderId));if(folder.id===parentId){parentId=result.newFolderId}const parentFolder=this.bookmarksService_.findBookmarkWithId(folder.parentId);parentFolder.children=parentFolder.children.filter((child=>!child.id.startsWith(TEMP_FOLDER_ID_PREFIX)))}this.bookmarksApi_.editBookmarks(event.detail.bookmarks.map((bookmark=>bookmark.id)),event.detail.name,event.detail.url,parentId);this.selectedBookmarks_={};this.editing_=false}setRenamingId_(event){this.renamingId_=event.detail.id}onRename_(event){const newName=event.detail.value;if(newName!=null){this.bookmarksApi_.renameBookmark(event.detail.bookmark.id,newName)}this.renamingId_=""}getDisplayListElement_(index){return this.shadowRoot.querySelector(`#shownBookmarksIronList${index}`)}notifyBookmarksListResize_(){for(let i=0;i<this.displayLists_.length;i++){if(this.displayLists_[i].length>0){this.getDisplayListElement_(i).notifyResize()}}}getFilterHeading_(index){if(index===0){return loadTimeData.getStringF("primaryFilterHeading",this.getActiveFolderLabel_())}return loadTimeData.getString("secondaryFilterHeading")}getSelectedDescription_(){return loadTimeData.getStringF("selectedBookmarkCount",this.getSelectedBookmarksLength_())}getSelectedBookmarksList_(){const selectedEntries=Object.entries(this.selectedBookmarks_).filter((([_id,selected])=>selected));const selectedIds=selectedEntries.map((([id,_selected])=>id));return selectedIds.map((id=>this.bookmarksService_.findBookmarkWithId(id)))}getSelectedBookmarksLength_(){return Object.values(this.selectedBookmarks_).filter((selected=>selected)).length}onLabelsChanged_(){this.labels_=[...this.$.labels.labels]}onBackClicked_(){this.recordCountMetricsOnNextUpdate_=true;this.pop("activeFolderPath_")}shouldHideBackButton_(){return!this.activeFolderPath_.length}onSearchChanged_(e){this.recordCountMetricsOnNextUpdate_=true;this.searchQuery_=e.detail.toLocaleLowerCase()}onSearchBlurred_(){chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.Search.CTR",SearchAction.SEARCHED,SearchAction.COUNT)}onContextMenuShown_(bookmark){this.contextMenuBookmark_=bookmark}onShowContextMenuClicked_(event){event.preventDefault();event.stopPropagation();if(!event.detail.bookmark){return}const priceTracked=!!this.bookmarksService_.getPriceTrackedInfo(event.detail.bookmark);const priceTrackingEligible=!!this.bookmarksService_.getAvailableProductInfo(event.detail.bookmark);const bookmark=event.detail.bookmark;const target=event.detail.event.target;if(event.detail.event.button===0){this.bookmarksApi_.isActiveTabInSplit().then((isSplit=>{this.$.contextMenu.showAt(target,[bookmark],priceTracked,priceTrackingEligible,isSplit,this.onContextMenuShown_.bind(this,bookmark))}))}else{this.bookmarksApi_.isActiveTabInSplit().then((isSplit=>{this.$.contextMenu.showAtPosition(event.detail.event,[bookmark],priceTracked,priceTrackingEligible,isSplit,this.onContextMenuShown_.bind(this,bookmark))}))}}getParentFolder_(){return this.getActiveFolder_()||this.bookmarksService_.findBookmarkWithId(loadTimeData.getString("otherBookmarksId"))}onShowSortMenuClicked_(event){event.preventDefault();event.stopPropagation();this.$.sortMenu.showAt(event.target)}onAddNewFolderClicked_(event){event.preventDefault();event.stopPropagation();const newParent=this.getParentFolder_();if(editingDisabledByPolicy([newParent])){this.showDisabledFeatureDialog_();return}chrome.metricsPrivate.recordUserAction(ADD_FOLDER_ACTION_UMA);this.bookmarksApi_.createFolder(newParent.id,loadTimeData.getString("newFolderTitle")).then((result=>{this.renamingId_=result.newFolderId}))}onBulkEditClicked_(event){event.preventDefault();event.stopPropagation();this.editing_=!this.editing_;if(!this.editing_){this.selectedBookmarks_={}}}onDeleteClicked_(event){event.preventDefault();event.stopPropagation();const selectedBookmarksList=this.getSelectedBookmarksList_();if(editingDisabledByPolicy(selectedBookmarksList)){this.showDisabledFeatureDialog_();return}this.bookmarksApi_.deleteBookmarks(selectedBookmarksList.map((bookmark=>bookmark.id))).then((()=>{this.showDeletionToastWithCount_(selectedBookmarksList.length);this.selectedBookmarks_={};this.editing_=false}))}onContextMenuEditClicked_(event){event.preventDefault();event.stopPropagation();if(editingDisabledByPolicy(event.detail.bookmarks)){this.showDisabledFeatureDialog_();return}this.showEditDialog_(event.detail.bookmarks,event.detail.bookmarks.length>1)}onContextMenuDeleteClicked_(event){event.preventDefault();event.stopPropagation();this.showDeletionToastWithCount_(event.detail.bookmarks.length);this.selectedBookmarks_={};this.editing_=false}onContextMenuClosed_(){if(!this.$.contextMenu.isOpen()){this.contextMenuBookmark_=undefined}}showDeletionToastWithCount_(deletionCount){PluralStringProxyImpl.getInstance().getPluralString("bookmarkDeletionCount",deletionCount).then((pluralString=>{this.deletionDescription_=pluralString;this.$.deletionToast.get().show()}))}showDisabledFeatureDialog_(){this.$.disabledFeatureDialog.showModal()}closeDisabledFeatureDialog_(){this.$.disabledFeatureDialog.close()}onUndoClicked_(){this.bookmarksApi_.undo();this.$.deletionToast.get().hide()}onMoveClicked_(event){event.preventDefault();event.stopPropagation();const selectedBookmarksList=this.getSelectedBookmarksList_();if(editingDisabledByPolicy(selectedBookmarksList)){this.showDisabledFeatureDialog_();return}this.showEditDialog_(selectedBookmarksList,true)}showEditDialog_(bookmarks,moveOnly){if(!this.isBookmarksInTransportModeEnabled){this.$.editDialog.showDialog(this.activeFolderPath_,this.bookmarksService_.getTopLevelBookmarks(),bookmarks,moveOnly);return}if(moveOnly){this.bookmarksApi_.contextMenuMove(bookmarks.map((bookmark=>bookmark.id)),ActionSource.kBookmark)}else{this.bookmarksApi_.contextMenuEdit(bookmarks.map((bookmark=>bookmark.id)),ActionSource.kBookmark)}}onBulkEditMenuClicked_(event){event.preventDefault();event.stopPropagation();const target=event.target;this.bookmarksApi_.isActiveTabInSplit().then((isSplit=>{this.$.contextMenu.showAt(target,this.getSelectedBookmarksList_(),false,false,isSplit)}))}onSortTypeClicked_(event){event.preventDefault();event.stopPropagation();this.$.sortMenu.close();this.activeSortIndex_=event.model.index;this.bookmarksApi_.setSortOrder(event.model.item.sortOrder);chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.SortTypeShown",event.model.item.sortOrder,SortOrder.kCount)}onViewToggleClicked_(event){event.preventDefault();event.stopPropagation();this.compact_=!this.compact_;if(this.bookmarksTreeViewEnabled_&&this.compact_){this.updateDisplayLists_()}this.notifyBookmarksListResize_();const viewType=this.compact_?ViewType.kCompact:ViewType.kExpanded;this.bookmarksApi_.setViewType(viewType);chrome.metricsPrivate.recordEnumerationValue("PowerBookmarks.SidePanel.ViewTypeShown",viewType,ViewType.kCount)}onAddTabClicked_(){const newParent=this.getParentFolder_();if(editingDisabledByPolicy([newParent])){this.showDisabledFeatureDialog_();return}chrome.metricsPrivate.recordUserAction(ADD_URL_ACTION_UMA);this.bookmarksApi_.bookmarkCurrentTabInFolder(newParent.id)}hideAddTabButton_(){return this.editing_||this.guestMode_}disableBackButton_(){return!this.activeFolderPath_.length||this.editing_}getEmptyTitle_(){if(this.guestMode_){return loadTimeData.getString("emptyTitleGuest")}else if(this.hasSomeActiveFilter_){return loadTimeData.getString("emptyTitleSearch")}else{return loadTimeData.getString("emptyTitle")}}getEmptyBody_(){if(this.guestMode_){return loadTimeData.getString("emptyBodyGuest")}else if(this.hasSomeActiveFilter_){return loadTimeData.getString("emptyBodySearch")}else{return loadTimeData.getString("emptyBody")}}getEmptyImagePath_(){return this.hasSomeActiveFilter_?"":"./images/bookmarks_empty.svg"}getEmptyImagePathDark_(){return this.hasSomeActiveFilter_?"":"./images/bookmarks_empty_dark.svg"}computeHasSomeActiveFilter_(){return!!this.searchQuery_||this.labels_.some((label=>label.active))}computeHasShownBookmarks_(){return this.displayLists_.some((list=>list.length>0))}computeSectionVisibility_(){if(this.guestMode_){return{topLevelEmptyState:true}}if(!this.hasLoadedData_){return{search:true,footer:true}}const hasActiveFolder=this.activeFolderPath_.length>0;const hasShownBookmarks=this.hasShownBookmarks_;const hasSomeActiveFilter=this.hasSomeActiveFilter_;return{search:true,labels:this.labels_.length>0,heading:!hasSomeActiveFilter&&(hasActiveFolder||hasShownBookmarks),filterHeadings:hasSomeActiveFilter,folderEmptyState:!hasShownBookmarks&&!hasSomeActiveFilter&&hasActiveFolder,newFolderButton:!hasSomeActiveFilter,bookmarksList:hasShownBookmarks,topLevelEmptyState:!hasShownBookmarks&&(hasSomeActiveFilter||!hasActiveFolder),footer:!hasSomeActiveFilter}}onShownBookmarksResize_(){this.notifyBookmarksListResize_();this.hasScrollbars_=this.$.bookmarks.scrollHeight>this.$.bookmarks.offsetHeight}}customElements.define(PowerBookmarksListElement.is,PowerBookmarksListElement);