import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="cr-icons cr-shared-style sp-shared-style">:host{--cr-dialog-body-padding-horizontal:16px;--cr-dialog-title-slot-padding-start:16px;--cr-dialog-width:300px;--cr-icon-button-margin-start:0}.body{display:flex;flex-direction:column}.button-row{font-size:12px;justify-content:space-between}.folder-row{box-sizing:border-box;align-items:center;display:flex;gap:8px;padding-inline-end:8px;width:100%}.folder-row:hover{background-color:var(--cr-hover-background-color)}.folder-row:focus-visible{outline-color:var(--cr-focus-outline-color)}.folder-row[selected]{background-color:var(--color-side-panel-bookmarks-selected-folder-background)}.folder-row[selected]>.cr-icon{background-color:var(--color-side-panel-bookmarks-selected-folder-icon)}.folder-row[selected]>.folder-title{color:var(--color-side-panel-bookmarks-selected-folder-foreground)}.folder-row[selected]>.subpage-arrow{--cr-icon-button-fill-color:var(--color-side-panel-bookmarks-selected-folder-icon)}.folder-row:has(.new-folder-input){margin-block-start:8px}.folder-selector{border:1px solid var(--color-side-panel-dialog-divider);border-radius:2px;height:160px;margin-top:8px;overflow:auto}.folder-title{width:100%}.input-label{align-items:center;display:flex;height:27px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;font-size:13px;color:var(--cr-primary-text-color)}.input-row{align-items:baseline;display:grid;gap:4px;grid-template-columns:52px auto}.input-section{display:flex;flex-direction:column;gap:8px;margin-bottom:16px}.name-input{--cr-icon-color:var(--cr-secondary-text-color);--cr-input-error-display:none}.new-folder-input{--cr-input-error-display:none;width:100%}</style>

<cr-dialog id="dialog">
  <div slot="title">[[getDialogTitle_(moveOnly_)]]</div>
  <div slot="body" class="body">
    <div class="input-section" hidden="[[moveOnly_]]">
      <div class="input-row name-input">
        <span class="input-label" aria-hidden="true">$i18n{editName}</span>
        <cr-input class="stroked" id="nameInput"
            value="[[getBookmarkName_(selectedBookmarks_.*)]]"
            aria-label="$i18n{editName}"></cr-input>
      </div>
      <div class="input-row">
        <span class="input-label" aria-hidden="true">$i18n{editUrl}</span>
        <cr-input class="stroked" id="urlInput" type="url"
            value="[[getBookmarkUrl_(selectedBookmarks_.*)]]"
            error-message="$i18n{editInvalidUrl}"
            aria-label="$i18n{editUrl}" required></cr-input>
      </div>
    </div>
    <sp-heading hide-back-button="[[!activeFolderPath_.length]]"
        back-button-title="$i18n{tooltipBack}"
        back-button-aria-label="[[getBackButtonLabel_(activeFolderPath_.*)]]"
        on-back-button-click="onBack_">
      <h2 slot="heading">[[getActiveFolderTitle_(activeFolderPath_.*)]]</h2>
    </sp-heading>
    <div id="folder-selector" class="folder-selector">
      <template is="dom-if" if="[[showNewFolderInput_]]"
          on-dom-change="onNewFolderInputDomChange_">
        <div class="folder-row">
          <div class="cr-icon icon-folder-open"></div>
          <cr-input class="stroked new-folder-input" id="newFolderInput"
              value="[[newFolderName_]]"
              on-value-changed="onInput_"
              on-blur="onBlur_"
              on-keydown="onKeyDown_"
              required></cr-input>
        </div>
      </template>
      <iron-list scroll-target="folder-selector"
          items="[[getShownFolders_(activeFolderPath_.*, topLevelBookmarks_,
                   newFolders_.*)]]">
        <template>
          <div class="folder-row"
              title="[[item.title]]"
              selected$="[[isSelected_(item, selectedFolder_)]]"
              on-click="onFolderSelected_"
              tabindex="0">
            <div class="cr-icon icon-folder-open"></div>
            <div class="folder-title">
              [[item.title]]
            </div>
            <template is="dom-if" restamp
                if="[[hasAvailableChildFolders_(item, newFolders_.*)]]">
              <cr-icon-button class="subpage-arrow"
                  title="[[getForwardButtonTooltip_(item)]]"
                  aria-label="[[getForwardButtonLabel_(item)]]"
                  on-click="onForward_">
              </cr-icon-button>
            </template>
          </div>
        </template>
      </iron-list>
    </div>
  </div>
  <div class="button-row" slot="button-container">
    <cr-button id="newFolderButton" on-click="onNewFolderClick_">
      $i18n{editNewFolder}
    </cr-button>
    <div>
      <cr-button on-click="onCancel_">$i18n{editCancel}</cr-button>
      <cr-button id="saveFolderButton" class="action-button cr-button-gap"
          on-click="onSave_">
        $i18n{editSave}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}