export interface MetricsReporting {
    enabled: boolean;
    managed: boolean;
}
export interface ResolverOption {
    name: string;
    value: string;
    policy: string;
}
/**
 * Contains the possible string values for the secure DNS mode. This must be
 * kept in sync with the mode names in chrome/browser/net/secure_dns_config.h.
 */
export declare enum SecureDnsMode {
    OFF = "off",
    AUTOMATIC = "automatic",
    SECURE = "secure"
}
/**
 * Contains the possible management modes. This should be kept in sync with
 * the management modes in chrome/browser/net/secure_dns_config.h.
 */
export declare enum SecureDnsUiManagementMode {
    NO_OVERRIDE = 0,
    DISABLED_MANAGED = 1,
    DISABLED_PARENTAL_CONTROLS = 2
}
export interface SecureDnsSetting {
    mode: SecureDnsMode;
    config: string;
    managementMode: SecureDnsUiManagementMode;
}
export interface PrivacyPageBrowserProxy {
    getSecureDnsResolverList(): Promise<ResolverOption[]>;
    getSecureDnsSetting(): Promise<SecureDnsSetting>;
    /**
     * @return true if the config string is syntactically valid.
     */
    isValidConfig(entry: string): Promise<boolean>;
    /**
     * @return True if a test query succeeded in the specified DoH
     *     configuration or the probe was cancelled.
     */
    probeConfig(entry: string): Promise<boolean>;
}
export declare class PrivacyPageBrowserProxyImpl implements PrivacyPageBrowserProxy {
    getSecureDnsResolverList(): Promise<any>;
    getSecureDnsSetting(): Promise<any>;
    isValidConfig(entry: string): Promise<boolean>;
    probeConfig(entry: string): Promise<boolean>;
    static getInstance(): PrivacyPageBrowserProxy;
    static setInstance(obj: PrivacyPageBrowserProxy): void;
}
