/**
 * @fileoverview 'settings-travel-page', is a subpage of the "Your saved info"
 * section. It manages the user's autofill data for traveling. Users can add,
 * edit, or delete their saved document details, as well as opt out of the
 * autofill functionality entirely.
 */
import '/shared/settings/prefs/prefs.js';
import '../autofill_page/autofill_ai_entries_list.js';
import '../autofill_page/your_saved_info_shared.css.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_subpage.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
export interface SettingsTravelPageElement {
    $: {
        optInToggle: SettingsToggleButtonElement;
    };
}
declare const SettingsTravelPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsTravelPageElement extends SettingsTravelPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
           Indicates if a user is eligible to change Enhanced Autofill data.
           If a user is not eligible for Enhanced Autofill (Autofill with Ai),
           but they have data saved, the code allows them only to edit and delete
           their data. They are not allowed to add new data, or to opt-in or
           opt-out of Enhanced Autofill using the corresponding toggle in this
           component. If a user is not eligible for Enhanced Autofill and they
           also have no data saved, then they cannot access this page at all.
         */
        enhancedAutofillEligibleUser_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        enhancedAutofillOptedIn_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
           Fake preference used by `this.$.optInToggle`. Shows value of
           `autofill.autofill_ai.travel_entities_enabled` preference if toggle
           is enabled (clickable). If toggle is disabled then the value is
           overridden to be shown as false even if the preference is true.
         */
        travelOptedIn_: {
            type: ObjectConstructor;
            computed: string;
        };
        /**
          If true, Autofill AI does not depend on whether Autofill for addresses
          is enabled.
        */
        autofillAiIgnoresWhetherAddressFillingIsEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
        };
    };
    static get observers(): string[];
    private enhancedAutofillEligibleUser_;
    private enhancedAutofillOptedIn_;
    private travelOptedIn_;
    private autofillAiIgnoresWhetherAddressFillingIsEnabled_;
    private entityDataManager_;
    connectedCallback(): void;
    private optInToggleDisabled_;
    private onAutofillOptInStatusChange_;
    private computeTravelOptedIn_;
    private onOptInToggleChange_;
    private getAllowedEntityTypes_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-travel-page': SettingsTravelPageElement;
    }
}
export {};
