/**
 * @fileoverview Settings that affect how Chrome interacts with the underlying
 * operating system (i.e. network, background processes, hardware).
 */
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '../controls/settings_toggle_button.js';
import '../relaunch_confirmation_dialog.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
export interface SettingsSystemPageElement {
    $: {
        proxy: HTMLElement;
        proxyMultipleSources: HTMLElement;
        hardwareAcceleration: SettingsToggleButtonElement;
    };
}
declare const SettingsSystemPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface);
export declare class SettingsSystemPageElement extends SettingsSystemPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        isProxyEnforcedByPolicy_: BooleanConstructor;
        isProxyDefault_: BooleanConstructor;
        isProxyEnforcedByMultipleSources_: BooleanConstructor;
    };
    static get observers(): string[];
    prefs: {
        proxy: chrome.settingsPrivate.PrefObject;
        proxy_override_rules: chrome.settingsPrivate.PrefObject;
    };
    private isProxyEnforcedByPolicy_;
    private isProxyDefault_;
    private isProxyEnforcedByMultipleSources_;
    private observeProxyPrefChanged_;
    private onExtensionDisable_;
    private onProxyClick_;
    private onRestartClick_;
    /**
     * @param enabled Whether hardware acceleration is currently enabled.
     */
    private shouldShowRestart_;
    searchContents(query: string): Promise<import("../search_settings.js").SearchResult>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-system-page': SettingsSystemPageElement;
    }
}
export {};
