/**
 * @fileoverview
 * 'settings-subpage' shows a subpage beneath a subheader. The header contains
 * the subpage title, a search field and a back icon.
 */
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_search_field/cr_search_field.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import type { FindShortcutListener } from '//resources/cr_elements/find_shortcut_manager.js';
import type { I18nMixinInterface } from '//resources/cr_elements/i18n_mixin.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route, RouteObserverMixinInterface } from '../router.js';
export interface SettingsSubpageElement {
    $: {
        closeButton: HTMLElement;
    };
}
declare const SettingsSubpageElementBase: {
    new (): PolymerElement & FindShortcutListener & I18nMixinInterface & RouteObserverMixinInterface;
};
export declare class SettingsSubpageElement extends SettingsSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        pageTitle: StringConstructor;
        /** Setting this will display the icon at the given URL. */
        titleIcon: StringConstructor;
        /** Setting this will display the favicon of the website. */
        faviconSiteUrl: StringConstructor;
        learnMoreUrl: StringConstructor;
        /** Setting a |searchLabel| will enable search. */
        searchLabel: StringConstructor;
        /** Setting a |searchIcon| will override the default search icon. */
        searchIcon: StringConstructor;
        searchTerm: {
            type: StringConstructor;
            notify: boolean;
            value: string;
        };
        /**
         * Whether we should hide the "close" button to get to the previous page.
         */
        hideCloseButton: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Whether the subpage search term should be preserved across navigations.
         */
        preserveSearchTerm: {
            type: BooleanConstructor;
            value: boolean;
        };
        active_: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
    };
    pageTitle: string;
    titleIcon: string;
    faviconSiteUrl: string;
    learnMoreUrl: string;
    searchLabel: string;
    searchIcon: string;
    searchTerm: string;
    hideCloseButton: boolean;
    preserveSearchTerm: boolean;
    private active_;
    private lastActiveValue_;
    private eventTracker_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private getSearchField_;
    /** Restore search field value from URL search param */
    private restoreSearchInput_;
    /** Preserve search field value to URL search param */
    private preserveSearchInput_;
    /** Focuses the back button when page is loaded. */
    focusBackButton(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private onActiveChanged_;
    /** Clear the value of the search field. */
    private onClearSubpageSearch_;
    private onBackClick_;
    private onHelpClick_;
    private onSearchChanged_;
    private getBackButtonAriaLabel_;
    private getBackButtonAriaRoleDescription_;
    private getLearnMoreAriaLabel_;
    handleFindShortcut(modalContextOpen: boolean): boolean;
    searchInputHasFocus(): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-subpage': SettingsSubpageElement;
    }
}
export {};
