/**
 * @fileoverview
 * 'settings-search-page' is the settings page containing search settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import './search_engine_list_dialog.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import '../site_favicon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsSearchPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSearchPageElement extends SettingsSearchPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        /**
         * List of search engines available.
         */
        searchEngines_: ArrayConstructor;
        defaultSearchEngine_: {
            type: ObjectConstructor;
            computed: string;
        };
        showSearchEngineListDialog_: BooleanConstructor;
        confirmationToastLabel_: StringConstructor;
    };
    prefs: Object;
    private searchEngines_;
    private showSearchEngineListDialog_;
    private defaultSearchEngine_;
    private browserProxy_;
    private isEeaChoiceCountry_;
    private confirmationToastLabel_;
    ready(): void;
    connectedCallback(): void;
    private onDisableExtension_;
    private onManageSearchEnginesClick_;
    private isDefaultSearchControlledByPolicy_;
    private isDefaultSearchEngineEnforced_;
    private computeDefaultSearchEngine_;
    private onOpenDialogButtonClick_;
    private onDefaultSearchEngineChangedInDialog_;
    private onSearchEngineListDialogClose_;
    private setFaviconSize_;
    getFocusConfig(): Map<string, string>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-search-page': SettingsSearchPageElement;
    }
}
export {};
