/**
 * @fileoverview 'settings-search-engine-entry' is a component for showing a
 * search engine with its name, domain and query URL.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_auto_img/cr_auto_img.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/policy/cr_policy_indicator.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import './search_engine_entry.css.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SearchEngine } from './search_engines_browser_proxy.js';
export interface SettingsSearchEngineEntryElement {
    $: {
        delete: HTMLButtonElement;
        makeDefault: HTMLButtonElement;
        edit: HTMLButtonElement;
        downloadedIcon: HTMLImageElement;
    };
}
declare const SettingsSearchEngineEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsSearchEngineEntryElement extends SettingsSearchEngineEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        engine: {
            type: ObjectConstructor;
            observer: string;
        };
        showShortcut: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        showQueryUrl: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        isDefault: {
            reflectToAttribute: boolean;
            type: BooleanConstructor;
            computed: string;
        };
        showEditIcon_: {
            type: BooleanConstructor;
            computed: string;
        };
        showDownloadedIcon_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showSecondaryButton_: {
            type: BooleanConstructor;
            computed: string;
        };
        disableDots_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    engine: SearchEngine;
    showShortcut: boolean;
    showQueryUrl: boolean;
    isDefault: boolean;
    private browserProxy_;
    private showEditIcon_;
    private showDownloadedIcon_;
    private showSecondaryButton_;
    private disableDots_;
    private timeoutId_;
    private onEngineChanged_;
    private closePopupMenu_;
    private computeIsDefault_;
    private computeShowEditIcon_;
    private computeShowSecondaryButton_;
    private computeDisableDots_;
    private onDeleteClick_;
    private onDotsClick_;
    private onViewOrEditClick_;
    private onMakeDefaultClick_;
    private onActivateClick_;
    private onDeactivateClick_;
    private onDownloadedIconLoadError_;
    private onDownloadedIconLoadSuccess_;
    private shouldShowDownloadedIcon_;
    private getMoreActionsAriaLabel_;
    private getActivateButtonAriaLabel_;
    private getEditButtonAriaLabel_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-search-engine-entry': SettingsSearchEngineEntryElement;
    }
}
export {};
