/**
 * @fileoverview 'settings-search-engine-edit-dialog' is a component for adding
 * or editing a search engine entry.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SearchEngine } from './search_engines_browser_proxy.js';
export interface SettingsSearchEngineEditDialogElement {
    $: {
        actionButton: CrButtonElement;
        cancel: CrButtonElement;
        dialog: CrDialogElement;
        keyword: CrInputElement;
        queryUrl: CrInputElement;
        searchEngine: CrInputElement;
    };
}
declare const SettingsSearchEngineEditDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSearchEngineEditDialogElement extends SettingsSearchEngineEditDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The search engine to be edited. If not populated a new search engine
         * should be added.
         */
        model: ObjectConstructor;
        searchEngine_: StringConstructor;
        keyword_: StringConstructor;
        queryUrl_: StringConstructor;
        dialogTitle_: StringConstructor;
        actionButtonText_: StringConstructor;
        showPolicySubtitle_: BooleanConstructor;
        readonly_: BooleanConstructor;
        urlIsReadonly_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    model: SearchEngine | null;
    private searchEngine_;
    private keyword_;
    private queryUrl_;
    private dialogTitle_;
    private actionButtonText_;
    private showPolicySubtitle_;
    private readonly_;
    private urlIsReadonly_;
    private browserProxy_;
    ready(): void;
    connectedCallback(): void;
    private enginesChanged_;
    private cancel_;
    private onActionButtonClick_;
    private validateElement_;
    private validate_;
    private updateActionButtonState_;
    private computeUrlIsReadonly_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-search-engine-edit-dialog': SettingsSearchEngineEditDialogElement;
    }
}
export {};
