/**
 * @fileoverview 'settings-omnibox-extension-entry' is a component for showing
 * an omnibox extension with its name and keyword.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import './search_engine_entry.css.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SearchEngine } from './search_engines_browser_proxy.js';
export interface SettingsOmniboxExtensionEntryElement {
    $: {
        disable: HTMLButtonElement;
        manage: HTMLButtonElement;
    };
}
declare const SettingsOmniboxExtensionEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/focus_row_mixin.js").FocusRowMixinInterface);
export declare class SettingsOmniboxExtensionEntryElement extends SettingsOmniboxExtensionEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        engine: ObjectConstructor;
    };
    engine: SearchEngine;
    private browserProxy_;
    private onManageClick_;
    private onDisableClick_;
    private closePopupMenu_;
    private onDotsClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-omnibox-extension-entry': SettingsOmniboxExtensionEntryElement;
    }
}
export {};
