/**
 * @fileoverview
 * 'settings-safety-hub-page' is the settings page that presents the safety
 * state of Chrome.
 */
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../relaunch_confirmation_dialog.js';
import '../settings_page/settings_subpage.js';
import './safety_hub_card.js';
import './safety_hub_module.js';
import './extensions_module.js';
import './notification_permissions_module.js';
import './unused_site_permissions_module.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
export interface SettingsSafetyHubPageElement {
    $: {
        passwords: HTMLElement;
        safeBrowsing: HTMLElement;
        version: HTMLElement;
    };
}
declare const SettingsSafetyHubPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsSafetyHubPageElement extends SettingsSafetyHubPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        passwordCardData_: ObjectConstructor;
        versionCardData_: ObjectConstructor;
        safeBrowsingCardData_: ObjectConstructor;
        showNotificationPermissions_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showUnusedSitePermissions_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showExtensions_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showNoRecommendationsState_: {
            type: BooleanConstructor;
            computed: string;
        };
        userEducationItemList_: ArrayConstructor;
        hasDataForNotificationPermissions_: BooleanConstructor;
        hasDataForUnusedPermissions_: BooleanConstructor;
        hasDataForExtensions_: BooleanConstructor;
        versionCardRole_: {
            type: StringConstructor;
            computed: string;
        };
        versionCardAriaDescription_: {
            type: StringConstructor;
            computed: string;
        };
    };
    static get observers(): string[];
    private passwordCardData_;
    private versionCardData_;
    private safeBrowsingCardData_;
    private showNotificationPermissions_;
    private hasDataForNotificationPermissions_;
    private showUnusedSitePermissions_;
    private hasDataForUnusedPermissions_;
    private showNoRecommendationsState_;
    private showExtensions_;
    private hasDataForExtensions_;
    private shouldRecordMetric_;
    private userEducationItemList_;
    private versionCardRole_;
    private versionCardAriaDescription_;
    private browserProxy_;
    private metricsBrowserProxy_;
    connectedCallback(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private initializeCards_;
    private initializeModules_;
    private initializeUserEducation_;
    private onPasswordsClick_;
    private onPasswordsKeyPress_;
    private onVersionClick_;
    private onEducationLinkClick_;
    private onVersionKeyPress_;
    private onSafeBrowsingPrefChanged_;
    private onSafeBrowsingClick_;
    private onSafeBrowsingKeyPress_;
    private onNotificationPermissionListChanged_;
    private onUnusedSitePermissionListChanged_;
    private computeShowNoRecommendationsState_;
    private onExtensionsChanged_;
    private computeVersionCardRole_;
    private computeVersionCardAriaDescription_;
    private isEnterOrSpaceClicked_;
    private onAllModulesLoaded_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-page': SettingsSafetyHubPageElement;
    }
}
export {};
