/**
 * @fileoverview
 * 'settings-safety-hub-module' is the settings page that presents the safety
 * state of Chrome.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import '../i18n_setup.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SiteInfo {
    origin: string;
    detail: string | TrustedHTML;
    icon?: string;
}
export interface SiteInfoWithTarget extends SiteInfo {
    target: EventTarget;
}
declare const SettingsSafetyHubModuleElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../tooltip_mixin.js").TooltipMixinInterface);
export declare class SettingsSafetyHubModuleElement extends SettingsSafetyHubModuleElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        sites: {
            type: ArrayConstructor;
            value: () => never[];
            observer: string;
        };
        animated: {
            type: BooleanConstructor;
            value: boolean;
        };
        header: StringConstructor;
        subheader: StringConstructor;
        headerIcon: {
            String: StringConstructor;
            observer: string;
        };
        headerIconColor: StringConstructor;
        buttonIcon: StringConstructor;
        buttonAriaLabelId: StringConstructor;
        buttonTooltipText: StringConstructor;
        moreActionVisible: {
            type: BooleanConstructor;
            value: boolean;
        };
        moreButtonAriaLabelId: StringConstructor;
    };
    sites: SiteInfo[];
    animated: boolean;
    header: string;
    subheader: string | TrustedHTML;
    headerIcon: string;
    headerIconColor: string;
    buttonIcon: string;
    buttonAriaLabelId: string;
    buttonTooltipText: string;
    moreButtonAriaLabelId: string;
    moreActionVisible: boolean;
    private modelUpdateDelayMsForTesting_;
    setModelUpdateDelayMsForTesting(delayMs: number): void;
    private setVisibility_;
    private addItemLinkClickListeners;
    private onSitesChanged_;
    /**
     * Hides |origin| and when the animation finishes, calls |callback|. If
     * |origin| is null, all origins are hidden.
     *
     * The |callback| method MUST be provided and MUST remove the |origin| from
     * the underlying model.
     */
    animateHide(origin: string | null, callback: Function): void;
    /**
     * Shows the given |origins| and calls |callback|.
     *
     * MUST be called once for each origin added, right after it is added.
     */
    animateShow(origins: string[], callback?: Function): void;
    /** Focus the main button for the given |origin|, if it exists. */
    focusOriginMainButton(origin: string): void;
    private finalizeAnimation_;
    private onItemButtonClick_;
    private onMoreActionClick_;
    private onHeaderIconChanged_;
    private onShowTooltip_;
    private sanitizeInnerHtml_;
    private getButtonAriaLabelForOrigin_;
    private getMoreButtonAriaLabelForOrigin_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-module': SettingsSafetyHubModuleElement;
    }
}
export {};
