import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_page/settings_section.js';
import './safety_hub_module.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { SettingsSafetyHubModuleElement } from './safety_hub_module.js';
export interface SettingsSafetyHubEntryPointElement {
    $: {
        button: HTMLElement;
        module: SettingsSafetyHubModuleElement;
    };
}
declare const SettingsSafetyHubEntryPointElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSafetyHubEntryPointElement extends SettingsSafetyHubEntryPointElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        buttonClass_: {
            type: BooleanConstructor;
            computed: string;
        };
        hasRecommendations_: {
            type: BooleanConstructor;
            value: boolean;
        };
        headerString_: StringConstructor;
        subheaderString_: StringConstructor;
        headerIconColor_: {
            type: StringConstructor;
            computed: string;
        };
    };
    private buttonClass_;
    private hasRecommendations_;
    private headerString_;
    private subheaderString_;
    private headerIconColor_;
    private safetyHubBrowserProxy_;
    private metricsBrowserProxy_;
    connectedCallback(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private computeButtonClass_;
    private computeHeaderIconColor_;
    private onClick_;
    getFocusConfig(): Map<string, string>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-entry-point': SettingsSafetyHubEntryPointElement;
    }
}
export {};
