/**
 * @fileoverview
 * 'settings-safety-hub-card' is used by the top cards in Safety Hub settings
 * page.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import type { CrIconElement } from 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { CardInfo } from './safety_hub_browser_proxy.js';
export interface SettingsSafetyHubCardElement {
    $: {
        icon: CrIconElement;
    };
}
export declare class SettingsSafetyHubCardElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        data: ObjectConstructor;
    };
    data: CardInfo;
    private getStatusIcon;
    private getColorClass;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-card': SettingsSafetyHubCardElement;
    }
}
