import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '../i18n_setup.js';
import './safety_hub_module.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * @fileoverview
 * 'settings-safety-hub-extensions-module' is used by the safety hub page
 * to alert users that they have potentially harmful extensions that they
 * should review.
 */
export interface SettingsSafetyHubExtensionsModuleElement {
    $: {
        reviewButton: HTMLElement;
    };
}
declare const SettingsSafetyHubExtensionsModuleElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSafetyHubExtensionsModuleElement extends SettingsSafetyHubExtensionsModuleElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        headerString_: StringConstructor;
    };
    private headerString_;
    connectedCallback(): Promise<void>;
    private onSafetyCheckExtensionsChanged_;
    private onButtonClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-extensions-module': SettingsSafetyHubExtensionsModuleElement;
    }
}
export {};
