/**
 * @fileoverview
 * 'settings-reset-page' is the settings page containing reset
 * settings.
 */
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import './reset_profile_dialog.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
import type { SettingsResetProfileDialogElement } from './reset_profile_dialog.js';
export interface SettingsResetPageElement {
    $: {
        resetProfileDialog: CrLazyRenderElement<SettingsResetProfileDialogElement>;
        resetProfile: HTMLElement;
    };
}
declare const SettingsResetPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsResetPageElement extends SettingsResetPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    /**
     * RouteObserverMixin
     */
    currentRouteChanged(route: Route): void;
    private onShowResetProfileDialog_;
    private onResetProfileDialogClose_;
    searchContents(query: string): Promise<import("../search_settings.js").SearchResult>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-reset-page': SettingsResetPageElement;
    }
}
export {};
