import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">#currentTopicsSection{align-items:center;display:flex;padding:0 var(--cr-section-padding)}.topics-empty-text{width:100%;display:flex;flex-direction:column;justify-content:center;align-items:center;text-align:center;padding-top:48px;padding-bottom:48px}#currentTopicsSectionWrapper{width:100%}#currentTopicsHeading{color:var(--cr-secondary-text-color);font-size:100%;font-weight:500;margin:0;padding-block-start:var(--cr-section-vertical-padding)}#currentTopicsDescription{padding-block-end:var(--cr-section-vertical-padding)}#disclaimer{padding:0 var(--cr-section-padding);padding-bottom:var(--cr-section-vertical-padding);color:var(--cr-secondary-text-color)}#learnMoreLink{background:none;border:none;color:var(--cr-link-color);cursor:pointer;margin:0;padding:0;text-decoration:underline}.no-topics{padding-block-end:32px;padding-block-start:16px;padding-inline-start:40px}#blockedTopicsDescription{color:var(--cr-secondary-text-color)}.no-blocked-topics{padding-inline-start:60px}#blockedTopicsList{padding:0 var(--cr-section-padding)}.footer{padding:16px var(--cr-section-padding)}a{color:var(--cr-link-color)}#dialog p{margin:0;padding-block-end:16px;padding-block-start:4px}cr-toast{--cr-toast-max-width:80%}</style>

<settings-subpage page-title="$i18n{topicsPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
<settings-toggle-button
    id="topicsToggle"
    pref="{{prefs.privacy_sandbox.m1.topics_enabled}}"
    label="$i18n{topicsPageToggleLabel}"
    sub-label="[[adTopicsToggleSubLabel_]]"
    on-settings-boolean-control-change="onToggleChange_">
</settings-toggle-button>
<div id="disclaimer">
  $i18nRaw{topicsPageDisclaimerDesktop}
</div>
<template is="dom-if" if="[[!emptyState_]]" restamp>
  <template is="dom-if" if="[[!isTopicsPrefManaged_(
      prefs.privacy_sandbox.m1.topics_enabled.enforcement)]]" restamp>
    <div id="currentTopicsSection">
      <div id="currentTopicsSectionWrapper" class="hr">
        <h2 id="currentTopicsHeading">$i18n{topicsPageActiveTopicsHeading}</h2>
        <template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescriptionV2" class="cr-secondary-text">
            $i18n{adTopicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescription" class="cr-secondary-text">
            $i18n{topicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[isTopicsEnabledAndLoaded_(
            prefs.privacy_sandbox.m1.topics_enabled.value,
            isTopicsListLoaded_)]]" restamp>
          <div role="region" aria-label=
              "$i18n{topicsPageCurrentTopicsRegionA11yDescription}">
            <template is="dom-repeat" items="[[topicsList_]]">
              <privacy-sandbox-interest-item interest="[[item]]"
                  on-interest-changed="onInterestChanged_">
              </privacy-sandbox-interest-item>
            </template>
          </div>
          <div id="currentTopicsEmptyText"
              class="topics-empty-text"
              hidden="[[!isTopicsListEmpty_(topicsList_.length)]]">
            <span id="currentTopicsDescriptionEmptyTextHeading">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyTextHeading}
            </span>
            <span id="currentTopicsDescriptionEmptyText"
                class="cr-secondary-text">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyText}
            </span>
          </div>
        </template>
        <div id="currentTopicsDescriptionDisabled"
            class="no-topics cr-secondary-text"
            hidden="[[prefs.privacy_sandbox.m1.topics_enabled.value]]">
          $i18n{topicsPageCurrentTopicsDescriptionDisabled}
        </div>
      </div>
    </div>
  </template>
   <cr-expand-button id="blockedTopicsRow" class="cr-row"
      expanded="{{blockedTopicsExpanded_}}">
      $i18n{topicsPageBlockedTopicsHeading}
    <div id="blockedTopicsDescription">
      $i18n{topicsPageBlockedTopicsDescription}
    </div>
  </cr-expand-button>
  <cr-collapse opened="[[blockedTopicsExpanded_]]">
    <div id="blockedTopicsEmptyText"
        class="topics-empty-text"
        hidden="[[!isBlockedTopicsListEmpty_(blockedTopicsList_.length)]]">
      <span id="blockedTopicsDescriptionEmptyTextHeading">
          $i18n{topicsPageBlockedTopicsDescriptionEmptyTextHeading}
      </span>
      <span id="blockedTopicsDescriptionEmptyText"
          class="cr-secondary-text">
        $i18n{topicsPageBlockedTopicsDescriptionEmptyText}
      </span>
    </div>
    <div id="blockedTopicsList" role="region"
        aria-label="$i18n{topicsPageBlockedTopicsRegionA11yDescription}">
      <template is="dom-repeat" items="[[blockedTopicsList_]]">
        <privacy-sandbox-interest-item interest="[[item]]"
            on-interest-changed="onInterestChanged_">
        </privacy-sandbox-interest-item>
      </template>
    </div>
  </cr-collapse>
  <div id="manageTopicsSection" class="hr">
      <cr-link-row id="privacySandboxManageTopicsLinkRow"
          label="$i18n{manageTopicsHeading}"
          sub-label="$i18n{manageTopicsDescription}"
          on-click="onPrivacySandboxManageTopicsClick_">
      </cr-link-row>
  </div>
</template>
<div id="footerV2" class="cr-secondary-text hr footer">
  $i18nRaw{adTopicsPageFooterV2Desktop}
</div>
<template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimerV2" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimerV2Desktop}
  </div>
</template>
<template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimer" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimer}
  </div>
</template>
<cr-toast id="unblockTopicToast" duration="10000">
  <div id="unblockTopicToastBody">$i18n{unblockTopicToastBody}</div>
  <cr-button id="closeToastButton" on-click="onHideToastClick_">
    $i18n{unblockTopicToastButtonText}
  </cr-button>
</cr-toast>
<template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="blockTopicDialog"
      title-text="[[blockTopicDialogTitle_]]"
      body-text="[[blockTopicDialogBody_]]"
      confirm-text="$i18n{topicsPageBlockTopic}"
      on-close="onBlockTopicDialogClose_">
  </settings-simple-confirmation-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}
