import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import '../../controls/controlled_radio_button.js';
import '../../controls/settings_radio_group.js';
import '../../icons.html.js';
import '../../controls/settings_toggle_button.js';
import '../../settings_page/settings_subpage.js';
import './security_page_feature_row.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ControlledRadioButtonElement } from '../../controls/controlled_radio_button.js';
import type { SettingsRadioGroupElement } from '../../controls/settings_radio_group.js';
import type { SettingsToggleButtonElement } from '../../controls/settings_toggle_button.js';
import type { Route } from '../../router.js';
import { SafeBrowsingSetting } from '../safe_browsing_types.js';
import type { SecurityPageFeatureRowElement } from './security_page_feature_row.js';
/** Enumeration of all security settings bundle modes.*/
export declare enum SecuritySettingsBundleSetting {
    STANDARD = 0,
    ENHANCED = 1
}
export interface SettingsSecurityPageV2Element {
    $: {
        bundlesRadioGroup: SettingsRadioGroupElement;
        passwordsLeakToggle: SettingsToggleButtonElement;
        resetEnhancedBundleToDefaultsButton: CrButtonElement;
        resetStandardBundleToDefaultsButton: CrButtonElement;
        securitySettingsBundleEnhanced: ControlledRadioButtonElement;
        securitySettingsBundleStandard: ControlledRadioButtonElement;
        safeBrowsingRadioGroup: SettingsRadioGroupElement;
        safeBrowsingRow: SecurityPageFeatureRowElement;
    };
}
declare const SettingsSecurityPageV2ElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../../settings_page/settings_view_mixin.js").SettingsViewMixinInterface) & (new (...args: any[]) => import("../../router.js").RouteObserverMixinInterface);
export declare class SettingsSecurityPageV2Element extends SettingsSecurityPageV2ElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        securitySettingsBundleSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SecuritySettingsBundleSetting;
        };
        safeBrowsingSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SafeBrowsingSetting;
        };
        isResetStandardBundleToDefaultsButtonVisible_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isResetEnhancedBundleToDefaultsButtonVisible_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isResettingToDefaults_: {
            type: BooleanConstructor;
            value: boolean;
        };
        safeBrowsingOff_: {
            type: ArrayConstructor;
            value: () => SafeBrowsingSetting[];
        };
        safeBrowsingStateTextMap_: {
            type: ObjectConstructor;
            value: () => {
                2: string;
                1: string;
                0: string;
            };
        };
    };
    static get observers(): string[];
    private isResettingToDefaults_;
    private isResetStandardBundleToDefaultsButtonVisible_;
    private isResetEnhancedBundleToDefaultsButtonVisible_;
    private safeBrowsingOff_;
    private safeBrowsingStateTextMap_;
    private lastFocusTime_;
    private totalTimeInFocus_;
    private interactions_;
    private safeBrowsingStateOnOpen_;
    private securitySettingsBundleStateOnOpen_;
    private isRouteSecurity_;
    private eventTracker_;
    private hatsBrowserProxy_;
    ready(): void;
    /**
     * RouteObserverMixin
     */
    currentRouteChanged(route: Route): void;
    /** Updates the total time in focus when the page loses focus. */
    private onBlur_;
    /**
     * Updates the timestamp when the user returns to this security page from
     * another tab.
     */
    private onFocus_;
    /**
     * Trigger the securityPageHatsRequest api to potentially start the survey.
     */
    private onBeforeUnload_;
    /**
     * Handles clicks on the safe browsing row.
     */
    private onSafeBrowsingRowClick_;
    /**
     * Handles changes of the radio button selection inside the safe browsing
     * settings row.
     */
    private onSafeBrowsingRadioChange_;
    focusBackButton(): void;
    private getBundleSetting_;
    private getDefaultSafeBrowsingValue_;
    private updateResetButtonVisibility_;
    private onSecurityBundleChanged_;
    private onResetBundleToDefaultsButtonClick_;
    private resetBundleToDefaults_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-page-v2': SettingsSecurityPageV2Element;
    }
}
export {};
