/**
 * @fileoverview 'settings-security-keys-bio-enroll-dialog' is a dialog for
 * listing, adding, renaming, and deleting biometric enrollments stored on a
 * security key.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import '../../settings_shared.css.js';
import '../../site_favicon.js';
import '../../i18n_setup.js';
import './fingerprint_icons.html.js';
import './fingerprint_progress_arc.js';
import './security_keys_pin_field.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { IronListElement } from 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { FingerprintProgressArcElement } from './fingerprint_progress_arc.js';
import type { SettingsSecurityKeysPinFieldElement } from './security_keys_pin_field.js';
export declare enum BioEnrollDialogPage {
    INITIAL = "initial",
    PIN_PROMPT = "pinPrompt",
    ENROLLMENTS = "enrollments",
    ENROLL = "enroll",
    CHOOSE_NAME = "chooseName",
    ERROR = "error"
}
export interface SettingsSecurityKeysBioEnrollDialogElement {
    $: {
        addButton: HTMLElement;
        arc: FingerprintProgressArcElement;
        cancelButton: CrButtonElement;
        confirmButton: CrButtonElement;
        dialog: CrDialogElement;
        error: HTMLElement;
        enrollmentList: IronListElement;
        enrollmentName: CrInputElement;
        pin: SettingsSecurityKeysPinFieldElement;
    };
}
declare const SettingsSecurityKeysBioEnrollDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSecurityKeysBioEnrollDialogElement extends SettingsSecurityKeysBioEnrollDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        cancelButtonDisabled_: BooleanConstructor;
        cancelButtonVisible_: BooleanConstructor;
        confirmButtonDisabled_: BooleanConstructor;
        confirmButtonVisible_: BooleanConstructor;
        confirmButtonLabel_: StringConstructor;
        deleteInProgress_: BooleanConstructor;
        /**
         * The ID of the element currently shown in the dialog.
         */
        dialogPage_: {
            type: StringConstructor;
            value: BioEnrollDialogPage;
            observer: string;
        };
        doneButtonVisible_: BooleanConstructor;
        /**
         * The list of enrollments displayed.
         */
        enrollments_: ArrayConstructor;
        minPinLength_: NumberConstructor;
        progressArcLabel_: StringConstructor;
        recentEnrollmentName_: StringConstructor;
        enrollmentNameError_: StringConstructor;
        enrollmentNameMaxUtf8Length_: NumberConstructor;
        errorMsg_: StringConstructor;
    };
    private cancelButtonDisabled_;
    private cancelButtonVisible_;
    private confirmButtonDisabled_;
    private confirmButtonVisible_;
    private confirmButtonLabel_;
    private deleteInProgress_;
    private dialogPage_;
    private doneButtonVisible_;
    private enrollments_;
    private minPinLength_;
    private progressArcLabel_;
    private recentEnrollmentName_;
    private enrollmentNameError_;
    private enrollmentNameMaxUtf8Length_;
    private errorMsg_;
    private browserProxy_;
    private maxSamples_;
    private recentEnrollmentId_;
    private showSetPINButton_;
    connectedCallback(): void;
    setDialogPageForTesting(page: BioEnrollDialogPage): void;
    private fire_;
    private onError_;
    private submitPin_;
    private onEnrollments_;
    setCancelButtonDisabledForTesting(disabled: boolean): void;
    private dialogPageChanged_;
    private addButtonClick_;
    private onEnrollmentSample_;
    private onEnrollmentComplete_;
    private confirmButtonClick_;
    private renameNewEnrollment_;
    private showEnrollmentsPage_;
    private cancel_;
    private done_;
    private onDialogClosed_;
    private onIronSelect_;
    private deleteEnrollment_;
    private onEnrollmentNameInput_;
    /**
     * @return The title string for the current dialog page.
     */
    private dialogTitle_;
    /**
     * @return The header label for the enrollments page.
     */
    private enrollmentsHeader_;
    private isNullOrEmpty_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-keys-bio-enroll-dialog': SettingsSecurityKeysBioEnrollDialogElement;
    }
}
export {};
