import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style md-select">:host(.no-hr) settings-toggle-button.hr{border-top:0}#resolverSelect{width:inherit}#resolverLabel{flex:1}#privacyPolicy{display:none;padding:calc(var(--cr-section-padding) / 2) var(--cr-section-padding)}#privacyPolicy a{color:var(--cr-link-color)}#secureDnsInputContainer{margin-top:calc(var(--cr-section-padding) / 2)}
    </style>

    <settings-toggle-button
        id="secureDnsToggle"
        class="hr"
        pref="{{secureDnsToggle_}}"
        label="$i18n{secureDns}"
        sub-label="[[secureDnsDescription_]]"
        on-change="onToggleChanged_">
    </settings-toggle-button>

    <div id="resolverOptions" hidden="[[!showSecureDnsOptions_]]">
      <div class="cr-row continuation">
        <div id="resolverLabel" class="flex cr-padded-text">
          $i18n{secureDnsSecureDropdownModeDescription}
        </div>

        <select id="resolverSelect"
            class="md-select"
            aria-labelledby="resolverLabel"
            on-change="onDropdownSelectionChanged_">
          <option value="[[resolverTypeEnum_.AUTOMATIC]]">
            $i18n{secureDnsAutomaticModeDescription}
          </option>
          <option value="[[resolverTypeEnum_.CUSTOM]]">
            $i18n{secureDnsCustomProviderDescription}
          </option>
          <template is="dom-repeat" items="[[resolverOptions_]]">
            <option data-resolver-type$="[[resolverTypeEnum_.BUILT_IN]]"
                value="[[index]]">
              [[item.name]]
            </option>
          </template>
        </select>
      </div>

      <div id="privacyPolicy">
        <div class="cr-secondary-text"
            inner-h-t-m-l="[[privacyPolicyString_]]"></div>
      </div>

      <div id="secureDnsInputContainer" class="cr-row continuation">
        <secure-dns-input id="secureDnsInput"
            value="[[secureDnsInputValue_]]"
            on-value-update="onSecureDnsInputEvaluated_">
        </secure-dns-input>
      </div>
    </div>
<!--_html_template_end_-->`;
}
