/**
 * @fileoverview
 * 'settings-privacy-guide-page' is the settings page that helps users guide
 * various privacy settings.
 */
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../../settings_shared.css.js';
import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import './privacy_guide_ad_topics_fragment.js';
import './privacy_guide_completion_fragment.js';
import './privacy_guide_cookies_fragment.js';
import './privacy_guide_history_sync_fragment.js';
import './privacy_guide_msbb_fragment.js';
import './privacy_guide_safe_browsing_fragment.js';
import './privacy_guide_welcome_fragment.js';
import './step_indicator.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../../router.js';
import { PrivacyGuideStep } from './constants.js';
import type { StepIndicatorModel } from './step_indicator.js';
export interface SettingsPrivacyGuidePageElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const PrivacyGuideBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("./privacy_guide_availability_mixin.js").PrivacyGuideAvailabilityMixinInterface) & (new (...args: any[]) => import("../../router.js").RouteObserverMixinInterface);
export declare class SettingsPrivacyGuidePageElement extends PrivacyGuideBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Valid privacy guide states.
         */
        privacyGuideStepEnum_: {
            type: ObjectConstructor;
            value: typeof PrivacyGuideStep;
        };
        /**
         * The current step in the privacy guide flow, or `undefined` if the flow
         * has not yet been initialized from query parameters.
         */
        privacyGuideStep_: {
            type: StringConstructor;
            value: undefined;
        };
        /**
         * Multiplier to apply on translate distances for animations in fragments.
         * +1 if navigating forwards LTR or backwards RTL; -1 if navigating
         * forwards RTL or backwards LTR.
         */
        translateMultiplier_: {
            type: NumberConstructor;
            value: number;
        };
        /**
         * Used by the 'step-indicator' element to display its dots.
         */
        stepIndicatorModel_: {
            type: ObjectConstructor;
            computed: string;
        };
        shouldShowAdTopicsCard_: {
            type: BooleanConstructor;
            value: boolean;
        };
        syncStatus_: ObjectConstructor;
    };
    static get observers(): string[];
    private privacyGuideStep_;
    private stepIndicatorModel_;
    private privacyGuideStepToComponentsMap_;
    private syncBrowserProxy_;
    private syncStatus_;
    private animationsEnabled_;
    private translateMultiplier_;
    private metricsBrowserProxy_;
    private privacyGuideBrowserProxy_;
    private shouldShowAdTopicsCard_;
    constructor();
    ready(): void;
    disableAnimationsForTesting(): void;
    /** RouteObserverBehavior */
    currentRouteChanged(newRoute: Route): void;
    /**
     * @return the map of privacy guide steps to their components.
     */
    private computePrivacyGuideStepToComponentsMap_;
    private exitIfNecessary;
    /** Handler for when the sync state is pushed from the browser. */
    private onSyncStatusChanged_;
    /** Update the privacy guide state based on changed prefs. */
    private onPrefsChanged_;
    private navigateForwardIfCurrentCardNoLongerAvailable;
    /** Sets the privacy guide step from the URL parameter. */
    private updateStateFromQueryParameters_;
    private onNextButtonClick_;
    private recordEligibleSteps_;
    private navigateForward_;
    private onBackButtonClick_;
    private navigateBackward_;
    private navigateToCard_;
    private computeBackButtonClass_;
    computeStepIndicatorModel(): StepIndicatorModel;
    private shouldShowHistorySyncCard_;
    private shouldShowCookiesCard_;
    private shouldShowSafeBrowsingCard_;
    private showAnySettingFragment_;
    private onKeyDown_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-privacy-guide-page': SettingsPrivacyGuidePageElement;
    }
}
export {};
