/**
 * @fileoverview
 * 'privacy-guide-completion-fragment' is the fragment in a privacy guide
 * card that contains the completion screen and its description.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import './privacy_guide_fragment_shared.css.js';
import '../../icons.html.js';
import '../../privacy_icons.html.js';
import '../../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface PrivacyGuideCompletionFragmentElement {
    $: {
        backButton: HTMLElement;
    };
}
declare const PrivacyGuideCompletionFragmentElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class PrivacyGuideCompletionFragmentElement extends PrivacyGuideCompletionFragmentElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        isNoLinkLayout_: {
            reflectToAttribute: boolean;
            type: BooleanConstructor;
            computed: string;
        };
        shouldShowAiSettings_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        shouldShowPrivacySandbox_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        shouldShowWaa_: {
            type: BooleanConstructor;
            value: boolean;
        };
        shouldShowV2AdPrivacySubLabel_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    private isNoLinkLayout_;
    private shouldShowAiSettings_;
    private shouldShowPrivacySandbox_;
    private shouldShowWaa_;
    private metricsBrowserProxy_;
    private shouldShowV2AdPrivacySubLabel_;
    private privacySandboxBrowserProxy_;
    ready(): void;
    focus(): void;
    private onViewEnterStart_;
    private computeIsNoLinkLayout_;
    private getSubheader_;
    /** Updates the completion card waa link depending on the signin state. */
    private updateWaaLink_;
    private onBackButtonClick_;
    private onLeaveButtonClick_;
    private onPrivacySandboxClick_;
    private onAiRowClick_;
    private onWaaClick_;
    private computePrivacySandboxRowSubLabel_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-guide-completion-fragment': PrivacyGuideCompletionFragmentElement;
    }
}
export {};
