// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * All Trust & Safety based interactions which may result in a HaTS survey.
 *
 * Must be kept in sync with the enum of the same name in hats_handler.h.
 */
export var TrustSafetyInteraction;
(function (TrustSafetyInteraction) {
    TrustSafetyInteraction[TrustSafetyInteraction["RAN_SAFETY_CHECK"] = 0] = "RAN_SAFETY_CHECK";
    TrustSafetyInteraction[TrustSafetyInteraction["USED_PRIVACY_CARD"] = 1] = "USED_PRIVACY_CARD";
    // OPENED_PRIVACY_SANDBOX = 2, // DEPRECATED
    TrustSafetyInteraction[TrustSafetyInteraction["OPENED_PASSWORD_MANAGER"] = 3] = "OPENED_PASSWORD_MANAGER";
    TrustSafetyInteraction[TrustSafetyInteraction["COMPLETED_PRIVACY_GUIDE"] = 4] = "COMPLETED_PRIVACY_GUIDE";
    TrustSafetyInteraction[TrustSafetyInteraction["RAN_PASSWORD_CHECK"] = 5] = "RAN_PASSWORD_CHECK";
    // OPENED_AD_PRIVACY = 6, // DEPRECATED
    // OPENED_TOPICS_SUBPAGE = 7, // DEPRECATED
    // OPENED_FLEDGE_SUBPAGE = 8, // DEPRECATED
    // OPENED_AD_MEASUREMENT_SUBPAGE = 9, // DEPRECATED
    // OPENED_GET_MOST_CHROME = 10, // DEPRECATED
})(TrustSafetyInteraction || (TrustSafetyInteraction = {}));
/**
 * Enumeration of interactions with the security settings v2 page. Must be kept
 * in sync with the enum of the same name located in:
 * chrome/browser/ui/webui/settings/hats_handler.h
 */
export var SecurityPageV2Interaction;
(function (SecurityPageV2Interaction) {
    SecurityPageV2Interaction[SecurityPageV2Interaction["STANDARD_BUNDLE_RADIO_BUTTON_CLICK"] = 0] = "STANDARD_BUNDLE_RADIO_BUTTON_CLICK";
    SecurityPageV2Interaction[SecurityPageV2Interaction["ENHANCED_BUNDLE_RADIO_BUTTON_CLICK"] = 1] = "ENHANCED_BUNDLE_RADIO_BUTTON_CLICK";
    SecurityPageV2Interaction[SecurityPageV2Interaction["SAFE_BROWSING_ROW_EXPANDED"] = 2] = "SAFE_BROWSING_ROW_EXPANDED";
    SecurityPageV2Interaction[SecurityPageV2Interaction["STANDARD_SAFE_BROWSING_RADIO_BUTTON_CLICK"] = 3] = "STANDARD_SAFE_BROWSING_RADIO_BUTTON_CLICK";
    SecurityPageV2Interaction[SecurityPageV2Interaction["ENHANCED_SAFE_BROWSING_RADIO_BUTTON_CLICK"] = 4] = "ENHANCED_SAFE_BROWSING_RADIO_BUTTON_CLICK";
})(SecurityPageV2Interaction || (SecurityPageV2Interaction = {}));
/** Enumeration of all security settings bundle modes.*/
// LINT.IfChange(SecuritySettingsBundleSetting)
export var SecuritySettingsBundleSetting;
(function (SecuritySettingsBundleSetting) {
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["STANDARD"] = 0] = "STANDARD";
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["ENHANCED"] = 1] = "ENHANCED";
})(SecuritySettingsBundleSetting || (SecuritySettingsBundleSetting = {}));
export class HatsBrowserProxyImpl {
    trustSafetyInteractionOccurred(interaction) {
        chrome.send('trustSafetyInteractionOccurred', [interaction]);
    }
    securityPageHatsRequest(securityPageInteractions, safeBrowsingSetting, totalTimeOnPage, securitySettingsBundleSetting) {
        chrome.send('securityPageHatsRequest', [
            securityPageInteractions,
            safeBrowsingSetting,
            totalTimeOnPage,
            securitySettingsBundleSetting,
        ]);
    }
    now() {
        return window.performance.now();
    }
    static getInstance() {
        return instance || (instance = new HatsBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
