/**
 * @fileoverview
 * 'settings-cookies-page' is the settings page containing cookies
 * settings.
 */
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import '../controls/collapse_radio_button.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../privacy_icons.html.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../site_settings/site_list.js';
import './do_not_track_toggle.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import { ContentSetting, ContentSettingsTypes, CookieControlsMode } from '../site_settings/constants.js';
import { ThirdPartyCookieBlockingSetting } from '../site_settings/site_settings_browser_proxy.js';
export interface SettingsCookiesPageElement {
    $: {
        toast: CrToastElement;
    };
}
declare const SettingsCookiesPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsCookiesPageElement extends SettingsCookiesPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Current search term.
         */
        searchTerm: {
            type: StringConstructor;
            notify: boolean;
            value: string;
        };
        /** Cookie control modes for use in bindings. */
        cookieControlsModeEnum_: {
            type: ObjectConstructor;
            value: typeof CookieControlsMode;
        };
        thirdPartyCookieBlockingSettingEnum_: {
            type: ObjectConstructor;
            value: typeof ThirdPartyCookieBlockingSetting;
        };
        contentSettingEnum_: {
            type: ObjectConstructor;
            value: typeof ContentSetting;
        };
        cookiesContentSettingType_: {
            type: StringConstructor;
            value: ContentSettingsTypes;
        };
        blockAllPref_: {
            type: ObjectConstructor;
            value(): {};
        };
        is3pcdRedesignEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
    };
    searchTerm: string;
    private cookiesContentSettingType_;
    private blockAllPref_;
    private is3pcdRedesignEnabled_;
    private metricsBrowserProxy_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private onSiteDataClick_;
    private onBlockAll3pcToggleChanged_;
    private showOrHideToast;
    private onCookieControlsModeChanged_;
    private onThirdPartyCookieBlockingSettingChanged_;
    private onPrivacySandboxClick_;
    private relatedWebsiteSetsToggleDisabled_;
    private relatedWebsiteSetsToggle3pcSettingDisabled_;
    getFocusConfig(): Map<string, string>;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-cookies-page': SettingsCookiesPageElement;
    }
}
export {};
