import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { PrefsMixinInterface } from '/shared/settings/prefs/prefs_mixin.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { ListPropertyUpdateMixinInterface } from 'chrome://resources/cr_elements/list_property_update_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ExceptionValidationMixinInterface } from './exception_validation_mixin.js';
export interface ExceptionEditInputElement {
    $: {
        input: CrInputElement;
    };
}
type Constructor<T> = new (...args: any[]) => T;
declare const ExceptionEditInputElementBase: Constructor<ExceptionValidationMixinInterface & ListPropertyUpdateMixinInterface & PrefsMixinInterface & PolymerElement>;
export declare class ExceptionEditInputElement extends ExceptionEditInputElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Represents the original rule that is being edited. When submit() is
         * called, it will be replaced by rule in the exception list.
         */
        ruleToEdit: {
            type: StringConstructor;
            value: string;
        };
    };
    private metricsProxy_;
    private ruleToEdit;
    ready(): void;
    submit(): void;
    setRuleToEditForTesting(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-discard-exception-edit-input': ExceptionEditInputElement;
    }
}
export {};
