import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import './exception_edit_input.js';
import type { PrefsMixinInterface } from '/shared/settings/prefs/prefs_mixin.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ExceptionEditInputElement } from './exception_edit_input.js';
export interface ExceptionEditDialogElement {
    $: {
        actionButton: CrButtonElement;
        cancelButton: CrButtonElement;
        dialog: CrDialogElement;
        input: ExceptionEditInputElement;
    };
}
type Constructor<T> = new (...args: any[]) => T;
declare const ExceptionEditDialogElementBase: Constructor<PrefsMixinInterface & PolymerElement>;
export declare class ExceptionEditDialogElement extends ExceptionEditDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        ruleToEdit: {
            type: StringConstructor;
            value: string;
        };
    };
    private ruleToEdit;
    private onCancelClick_;
    private onSubmitClick_;
    setRuleToEditForTesting(rule: string): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-discard-exception-edit-dialog': ExceptionEditDialogElement;
    }
}
export {};
