import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_input/cr_input.js';
import '//resources/cr_elements/cr_radio_button/cr_radio_button.js';
import '//resources/cr_elements/cr_radio_group/cr_radio_group.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SyncPrefs, SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
export declare class SettingsSyncEncryptionOptionsElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        syncPrefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        syncStatus: ObjectConstructor;
        existingPassphraseLabel: {
            type: StringConstructor;
        };
        /**
         * Whether the "create passphrase" inputs should be shown. These inputs
         * give the user the opportunity to use a custom passphrase instead of
         * authenticating with their Google credentials.
         */
        creatingNewPassphrase_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The passphrase input field value.
         */
        passphrase_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * The passphrase confirmation input field value.
         */
        confirmation_: {
            type: StringConstructor;
            value: string;
        };
        disableEncryptionOptions_: {
            type: BooleanConstructor;
            computed: string;
            observer: string;
        };
    };
    syncPrefs: SyncPrefs | null;
    syncStatus: SyncStatus | null;
    existingPassphraseLabel: string;
    private creatingNewPassphrase_;
    private passphrase_;
    private confirmation_;
    private disableEncryptionOptions_;
    private isSettingEncryptionPassphrase_;
    constructor();
    /**
     * Whether we should disable the radio buttons that allow choosing the
     * encryption options for Sync.
     * We disable the buttons if:
     * (a) full data encryption is enabled, or,
     * (b) full data encryption is not allowed (so far, only applies to
     * supervised accounts), or,
     * (c) current encryption keys are missing, or,
     * (d) the user is a supervised account.
     */
    private computeDisableEncryptionOptions_;
    private disableEncryptionOptionsChanged_;
    /**
     * @param passphrase The passphrase input field value
     * @param confirmation The passphrase confirmation input field value.
     * @return Whether the passphrase save button should be enabled.
     */
    private isSaveNewPassphraseEnabled_;
    private onNewPassphraseInputKeypress_;
    private onSaveNewPassphraseClick_;
    /**
     * Sends the newly created custom sync passphrase to the browser.
     */
    private saveNewPassphrase_;
    private onEncryptionRadioSelectionChanged_;
    /**
     * Computed binding returning the selected encryption radio button.
     */
    private selectedEncryptionRadio_;
    /**
     * Checks the supplied passphrases to ensure that they are not empty and that
     * they match each other. Additionally, displays error UI if they are invalid.
     * @return Whether the check was successful (i.e., that the passphrases were
     *     valid).
     */
    private validateCreatedPassphrases_;
    private onLearnMoreClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-sync-encryption-options': SettingsSyncEncryptionOptionsElement;
    }
}
