/**
 * @fileoverview
 * 'settings-sync-account-section' is the settings page containing sign-in
 * settings.
 */
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '/shared/settings/people_page/profile_info_browser_proxy.js';
import '../icons.html.js';
import '/shared/settings/prefs/prefs.js';
import '../settings_shared.css.js';
import type { CrButtonElement } from '//resources/cr_elements/cr_button/cr_button.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ChromeSigninAccessPoint, SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { Route } from '../router.js';
export interface SettingsSyncAccountControlElement {
    $: {
        signIn: CrButtonElement;
    };
}
declare const SettingsSyncAccountControlElementBase: typeof PolymerElement & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSyncAccountControlElement extends SettingsSyncAccountControlElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The current sync status, supplied by parent element.
         */
        syncStatus: ObjectConstructor;
        promoLabelWithAccount: StringConstructor;
        promoLabelWithNoAccount: StringConstructor;
        promoSecondaryLabelWithAccount: StringConstructor;
        promoSecondaryLabelWithNoAccount: StringConstructor;
        /**
         * Proxy variable for syncStatus.signedInState to shield observer from
         * being triggered multiple times whenever syncStatus changes.
         */
        syncing_: {
            type: BooleanConstructor;
            computed: string;
            observer: string;
        };
        storedAccounts_: ObjectConstructor;
        profileAvatarURL_: {
            type: StringConstructor;
            value: null;
            observer: string;
        };
        shownAccount_: ObjectConstructor;
        embeddedInSubpage: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
        };
        hideButtons: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        hideBanner: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        accessPoint: {
            type: NumberConstructor;
            reflectToAttribute: boolean;
        };
        shouldShowAvatarRow_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
            observer: string;
        };
        shouldShowSigninPausedButtons_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
            observer: string;
        };
        subLabel_: {
            type: StringConstructor;
            computed: string;
        };
        showSetupButtons_: {
            type: BooleanConstructor;
            computed: string;
        };
        promoType_: {
            type: StringConstructor;
            reflectToAttribute: boolean;
        };
    };
    static get observers(): string[];
    syncStatus: SyncStatus;
    promoLabelWithAccount: string;
    promoLabelWithNoAccount: string;
    promoSecondaryLabelWithAccount: string;
    promoSecondaryLabelWithNoAccount: string;
    private syncing_;
    private storedAccounts_;
    private profileAvatarURL_;
    private shownAccount_;
    embeddedInSubpage: boolean;
    hideButtons: boolean;
    hideBanner: boolean;
    accessPoint: ChromeSigninAccessPoint;
    private shouldShowAvatarRow_;
    private subLabel_;
    private showSetupButtons_;
    private shouldShowSigninPausedButtons_;
    private signinPausedImpressionRecorded_;
    private syncBrowserProxy_;
    private promoType_;
    connectedCallback(): void;
    currentRouteChanged(_newRoute: Route, _oldRoute?: Route): void;
    /**
     * Records Signin_Impression_FromSettings user action.
     */
    private recordImpressionUserActions_;
    private onSyncChanged_;
    private getLabel_;
    private computeSubLabel_;
    private getSubstituteLabel_;
    private getAccountLabel_;
    private shouldHideSubtitleWithAccountInfoText_;
    private getAvatarSubtitleLabel_;
    private getAccountAwareSigninButtonLabel_;
    private getProfileImageSrc_;
    private getAccountImageSrc_;
    /**
     * @return The CSS class of the sync icon.
     */
    private getSyncIconStyle_;
    /**
     * Returned value must match one of iron-icon's settings:(*) icon name.
     */
    private getSyncIcon_;
    private getAvatarRowTitle_;
    /**
     * Determines if the signout button should be hidden.
     */
    private shouldHideSignoutButton_;
    /**
     * Determines if the remove account button should be hidden.
     */
    private shouldHideRemoveAccountButton_;
    /**
     * Determines if the sync button should be disabled in response to
     * either a first setup flow or chrome sign-in being disabled.
     */
    private shouldDisableSyncButton_;
    /**
     * Determines whether the banner should be hidden, in the case where the user
     * has sync enabled or if the property to hide the banner was explicitly set.
     */
    private shouldHideBanner_;
    /**
     * Determines whether the sync button should be hidden, in the case where
     * `replaceSyncPromosWithSignInPromos` is enabled, the user has sync enabled,
     * is in sign in paused, or if the property to hide the banner was explicitly
     * set.
     */
    private shouldHideSyncButton_;
    private shouldShowTurnOffButton_;
    private getTurnOffSyncLabel_;
    private shouldShowErrorActionButton_;
    private shouldShowAccountAwareSigninButton_;
    private shouldAllowAccountSwitch_;
    private handleStoredAccounts_;
    private handleUpdateAvatar_;
    private computeShouldShowAvatarRow_;
    private onErrorButtonClick_;
    private onSigninClick_;
    private onSignoutClick_;
    private onDropdownClose_;
    private onSyncButtonClick_;
    private onTurnOffButtonClick_;
    private onMenuButtonClick_;
    private onShouldShowAvatarRowChange_;
    private onAccountClick_;
    private onShownAccountShouldChange_;
    private computeShowSetupButtons_;
    private onSetupCancel_;
    private onSetupConfirm_;
    private computeShouldShowSigninPausedButtons_;
    private maybeRecordSigninPendingOffered_;
    private isSyncing_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-sync-account-control': SettingsSyncAccountControlElement;
    }
}
export {};
