import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">.sync-row{align-items:center;flex:auto}#profile-icon{background:center/cover no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}#sync-setup{--cr-secondary-text-color:var(--settings-error-color)}#sync-not-allowed{border-top:var(--cr-separator-line);background:var(--google-grey-100)}#sync-not-allowed-text{margin-left:8px}cr-link-row{--cr-link-row-icon-width:40px;border-top:var(--cr-separator-line)}.icon-container{display:flex;flex-shrink:0;justify-content:center;width:40px}#toast{left:0;z-index:1}:host-context([dir='rtl']) #toast{left:auto;right:0}settings-sync-account-control[showing-promo]::part(banner){border-top-left-radius:var(--cr-card-border-radius);border-top-right-radius:var(--cr-card-border-radius)}settings-sync-account-control[showing-promo]::part(title){font-size:1.1rem;line-height:1.625rem}@media (prefers-color-scheme:dark){#sync-not-allowed{background:var(--google-grey-800)}}
    </style>
    <settings-section page-title="$i18n{peoplePageTitle}">
      <div>


        <template is="dom-if" if="[[shouldShowSyncAccountControl_(
            syncStatus.syncSystemEnabled, syncStatus.signedInStatus)]]" restamp>
          <settings-sync-account-control
              sync-status="[[syncStatus]]"
              prefs="{{prefs}}"
              promo-label-with-account="$i18n{peopleSignInPrompt}"
              promo-label-with-no-account="$i18n{peopleSignInPrompt}"
              promo-secondary-label-with-account=
                  "$i18n{peopleSignInPromptSecondaryWithAccount}"
              promo-secondary-label-with-no-account=
                  "$i18n{peopleSignInPromptSecondaryWithNoAccount}"
              access-point="[[accessPointEnum_.SETTINGS]]">
          </settings-sync-account-control>
        </template>

        <template is="dom-if" if="[[shouldLinkToProfileRow_(
            syncStatus.syncSystemEnabled, signinAllowed_,
            syncStatus.signedInState)]]" restamp>
          <div id="profile-row" class="cr-row first two-line"
              actionable$="[[isProfileActionable_]]"
              on-click="onProfileClick_">
            <template is="dom-if" if="[[syncStatus]]">
              <div id="profile-icon"
                  style="background-image: [[getIconImageSet_(
                      profileIconUrl_)]]">
              </div>
              <div class="flex cr-row-gap cr-padded-text text-elide">
                <span id="profile-name">[[profileName_]]</span>
              </div>
              <cr-icon-button class="subpage-arrow"
                  aria-label="$i18n{editPerson}"
                  aria-describedby="profile-name"
                  aria-roledescription="$i18n{subpageArrowRoleDescription}">
              </cr-icon-button>
            </template>
          </div>
        </template>

        <cr-link-row id="account-subpage-row" on-click="onAccountClick_"
            hidden="[[!shouldLinkToAccountSettingsPage_(
              syncStatus.signedInState)]]">
          <div id="profile-icon"
              style="background-image: [[getIconImageSet_(
                  primaryAccountIconUrl_)]]">
          </div>
          <div class="cr-row-gap cr-padded-text flex no-min-width">
            <div id="account-name" class="text-elide">
              [[primaryAccountName_]]
            </div>
            <div id="account-subtitle" class="secondary">
              [[getAccountRowSubtitle_(primaryAccountEmail_, syncStatus)]]
            </div>
          </div>
        </cr-link-row>

        <cr-link-row id="sync-setup"
            label="$i18n{syncAndNonPersonalizedServices}"
            on-click="onSyncClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            hidden="[[shouldHideSyncSetupLinkRow_(syncStatus)]]">
        </cr-link-row>
        <cr-link-row id="google-services"
            label="$i18n{googleServicesPageTitle}"
            on-click="onGoogleServicesClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            hidden="[[!shouldHideSyncSetupLinkRow_(syncStatus)]]">
        </cr-link-row>

        <template is="dom-if" if="[[signinAllowed_]]">
          <cr-link-row id="manage-google-account"
              label="$i18n{manageGoogleAccount}"
              hidden="[[!shouldShowGoogleAccount_]]"
              on-click="openGoogleAccount_" external></cr-link-row>

          <cr-link-row id="edit-profile"
              label="$i18n{profileNameAndPicture}"
              on-click="onProfileClick_" ></cr-link-row>
        </template>

        <cr-link-row id="importDataDialogTrigger"
            label="$i18n{importTitle}"
            on-click="onImportDataClick_"></cr-link-row>

        <template is="dom-if" if="[[isDasherlessProfile_]]">
          <div id="sync-not-allowed" class="cr-row continuation">
            <cr-icon id="info-icon" icon="cr:info-outline"></cr-icon>
            <div id="sync-not-allowed-text" class="flex cr-padded-text">
              $i18n{syncUnavailableForNonGoogleAccount}
            </div>
          </div>
        </template>




      </div>
    </settings-section>


    <template is="dom-if" if="[[showSignoutDialog_]]" restamp>
      <settings-signout-dialog sync-status="[[syncStatus]]"
          on-close="onDisconnectDialogClosed_">
      </settings-signout-dialog>
    </template>

    <template is="dom-if" if="[[showImportDataDialog_]]" restamp>
      <settings-import-data-dialog prefs="{{prefs}}"
          on-close="onImportDataDialogClosed_">
      </settings-import-data-dialog>
    </template>

    <cr-toast duration="3000" id="toast">
      <span>$i18n{syncSettingsSavedToast}</span>
    </cr-toast>
<!--_html_template_end_-->`;
}
