/**
 * @fileoverview
 * 'settings-people-page' is the settings page containing sign-in settings.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/policy/cr_policy_indicator.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../controls/settings_toggle_button.js';
import './sync_account_control.js';
import '../icons.html.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import type { StoredAccount, SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import { ChromeSigninAccessPoint } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
export interface SettingsPeoplePageElement {
    $: {
        importDataDialogTrigger: HTMLElement;
        toast: CrToastElement;
    };
}
declare const SettingsPeoplePageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsPeoplePageElement extends SettingsPeoplePageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        /**
         * This flag is used to conditionally show a set of new sign-in UIs to the
         * profiles that have been migrated to be consistent with the web
         * sign-ins.
         * TODO(tangltom): In the future when all profiles are completely
         * migrated, this should be removed, and UIs hidden behind it should
         * become default.
         */
        signinAllowed_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * This property stores whether the profile is a Dasherless profiles,
         * which is associated with a non-Dasher account. Some UIs related to
         * sign in and sync service will be different because they are not
         * available for these profiles.
         */
        isDasherlessProfile_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * Stored accounts to the system, supplied by SyncBrowserProxy.
         */
        storedAccounts: ObjectConstructor;
        /**
         * The current sync status, supplied by SyncBrowserProxy.
         */
        syncStatus: ObjectConstructor;
        /**
         * Authentication token provided by settings-lock-screen.
         */
        authToken_: {
            type: StringConstructor;
            value: string;
        };
        /**
         * The currently selected profile icon URL. May be a data URL.
         */
        profileIconUrl_: StringConstructor;
        /**
         * Whether the profile row is clickable. The behavior depends on the
         * platform.
         */
        isProfileActionable_: {
            type: BooleanConstructor;
            value(): boolean;
            readOnly: boolean;
        };
        /**
         * The current profile name.
         */
        profileName_: StringConstructor;
        shouldShowGoogleAccount_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        replaceSyncPromosWithSignInPromos_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showImportDataDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showSignoutDialog_: BooleanConstructor;
        primaryAccountName_: StringConstructor;
        primaryAccountEmail_: StringConstructor;
        primaryAccountIconUrl_: StringConstructor;
        accessPointEnum_: {
            type: ObjectConstructor;
            value: typeof ChromeSigninAccessPoint;
        };
    };
    prefs: any;
    private signinAllowed_;
    private isDasherlessProfile_;
    syncStatus: SyncStatus | null;
    private authToken_;
    private profileIconUrl_;
    private isProfileActionable_;
    private profileName_;
    storedAccounts: StoredAccount[] | null;
    private shouldShowGoogleAccount_;
    private replaceSyncPromosWithSignInPromos_;
    private showImportDataDialog_;
    private showSignoutDialog_;
    private primaryAccountName_;
    private primaryAccountEmail_;
    private primaryAccountIconUrl_;
    private syncBrowserProxy_;
    connectedCallback(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    /**
     * Handler for when the profile's icon and name is updated.
     */
    private handleProfileInfo_;
    /**
     * Handler for when the sync state is pushed from the browser.
     */
    private handleSyncStatus_;
    private computeShouldShowGoogleAccount_;
    private onProfileClick_;
    private onDisconnectDialogClosed_;
    private onSyncClick_;
    private onAccountClick_;
    private onGoogleServicesClick_;
    private onImportDataClick_;
    private onImportDataDialogClosed_;
    private shouldLinkToAccountSettingsPage_;
    private shouldLinkToProfileRow_;
    private shouldShowSyncAccountControl_;
    private handleStoredAccounts_;
    /**
     * Open URL for managing your Google Account.
     */
    private openGoogleAccount_;
    /**
     * @return A CSS image-set for multiple scale factors.
     */
    private getIconImageSet_;
    private isSyncing_;
    private shouldHideSyncSetupLinkRow_;
    private getAccountRowSubtitle_;
    getFocusConfig(): Map<any, any>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-people-page': SettingsPeoplePageElement;
    }
}
export {};
