/**
 * @fileoverview
 * 'settings-manage-profile' is the settings subpage containing controls to
 * edit a profile's name, icon, and desktop shortcut.
 */
import 'chrome://resources/cr_components/theme_color_picker/theme_color_picker.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_profile_avatar_selector/cr_profile_avatar_selector.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { AvatarIcon } from 'chrome://resources/cr_elements/cr_profile_avatar_selector/cr_profile_avatar_selector.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
declare const SettingsManageProfileElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export interface SettingsManageProfileElement {
    $: {
        nameInput: CrInputElement;
    };
}
export declare class SettingsManageProfileElement extends SettingsManageProfileElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The newly selected avatar. Defaults to null, populated only if the user
         * manually changes the avatar selection. The observer ensures that the
         * changes are propagated to the C++.
         */
        profileAvatar_: {
            type: ObjectConstructor;
            observer: string;
        };
        /**
         * The current profile name.
         */
        profileName_: StringConstructor;
        /**
         * True if the current profile has a shortcut.
         */
        hasProfileShortcut_: BooleanConstructor;
        /**
         * The available icons for selection.
         */
        availableIcons: {
            type: ArrayConstructor;
            value(): never[];
        };
        /**
         * True if the profile shortcuts feature is enabled.
         */
        isProfileShortcutSettingVisible_: BooleanConstructor;
        hasEnterpriseLabel_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * TODO(dpapad): Move this back to the HTML file when the Polymer2 version
         * of the code is deleted. Because of "\" being a special character in a
         * JS string, can't satisfy both Polymer2 and Polymer3 at the same time
         * from the HTML file.
         */
        pattern_: {
            type: StringConstructor;
            value: string;
        };
    };
    private profileAvatar_;
    private profileName_;
    private hasProfileShortcut_;
    availableIcons: AvatarIcon[];
    private isProfileShortcutSettingVisible_;
    private hasEnterpriseLabel_;
    private pattern_;
    private browserProxy_;
    connectedCallback(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private onProfileInfoChanged_;
    /**
     * Handler for when the profile name field is changed, then blurred.
     */
    private onNameInputChange_;
    /**
     * Handler for profile name keydowns.
     */
    private onNameInputKeydown_;
    /**
     * Handler for when the profile avatar is changed by the user.
     */
    private profileAvatarChanged_;
    /**
     * Handler for when the profile shortcut toggle is changed.
     */
    private onHasProfileShortcutChange_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-manage-profile': SettingsManageProfileElement;
    }
}
export {};
