import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared action-link">#editOptions>div{border-top:var(--cr-separator-line)}#outer{display:flex;flex-direction:column;max-height:355px}#container settings-startup-url-entry{cursor:default}
    </style>
    <div id="outer" class="flex list-frame">
      <div id="container" class="scroll-container" scrollable>
        <iron-list items="[[startupPages_]]" scroll-target="container"
            preserve-focus risk-selection class="cr-separators">
          <template>
            <settings-startup-url-entry model="[[item]]" first$="[[!index]]"
                tabindex$="[[tabIndex]]" iron-list-tab-index="[[tabIndex]]"
                last-focused="{{lastFocused_}}" list-blurred="{{listBlurred_}}"
                focus-row-index="[[index]]" editable="[[shouldAllowUrlsEdit_(
                    prefs.session.startup_urls.enforcement)]]">
            </settings-startup-url-entry>
          </template>
        </iron-list>
      </div>
    </div>
    <div id="editOptions" class="list-frame">
      <template is="dom-if" if="[[shouldAllowUrlsEdit_(
          prefs.session.startup_urls.enforcement)]]" restamp>
        <div class="list-item" id="addPage">
          <a is="action-link" class="list-button" on-click="onAddPageClick_">
            $i18n{onStartupAddNewPage}
          </a>
        </div>
        <div class="list-item" id="useCurrentPages">
          <a is="action-link" class="list-button"
              on-click="onUseCurrentPagesClick_">
            $i18n{onStartupUseCurrent}
          </a>
        </div>
      </template>
      <template is="dom-if" if="[[prefs.session.startup_urls.extensionId]]"
          restamp>
        <extension-controlled-indicator
            extension-id="[[prefs.session.startup_urls.extensionId]]"
            extension-name="[[prefs.session.startup_urls.controlledByName]]"
            extension-can-be-disabled="[[
                prefs.session.startup_urls.extensionCanBeDisabled]]">
        </extension-controlled-indicator>
      </template>
    </div>
    <template is="dom-if" if="[[showStartupUrlDialog_]]" restamp>
      <settings-startup-url-dialog model="[[startupUrlDialogModel_]]"
          on-close="destroyUrlDialog_">
      </settings-startup-url-dialog>
    </template>
<!--_html_template_end_-->`;
}
