/**
 * @fileoverview 'settings-startup-urls-page' is the settings page
 * containing the urls that will be opened when chrome is started.
 */
import 'chrome://resources/js/action_link.js';
import 'chrome://resources/cr_elements/action_link.css.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '../settings_shared.css.js';
import './startup_url_dialog.js';
import './startup_url_entry.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsStartupUrlsPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../scrollable_mixin.js").ScrollableMixinInterface);
export declare class SettingsStartupUrlsPageElement extends SettingsStartupUrlsPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        /**
         * Pages to load upon browser startup.
         */
        startupPages_: ArrayConstructor;
        showStartupUrlDialog_: BooleanConstructor;
        startupUrlDialogModel_: ObjectConstructor;
        lastFocused_: ObjectConstructor;
        listBlurred_: BooleanConstructor;
    };
    prefs: Object;
    private startupPages_;
    private showStartupUrlDialog_;
    private startupUrlDialogModel_;
    private lastFocused_;
    private listBlurred_;
    private browserProxy_;
    private startupUrlDialogAnchor_;
    constructor();
    connectedCallback(): void;
    private onAddPageClick_;
    private destroyUrlDialog_;
    private onUseCurrentPagesClick_;
    /**
     * @return Whether "Add new page" and "Use current pages" are allowed.
     */
    private shouldAllowUrlsEdit_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-startup-urls-page': SettingsStartupUrlsPageElement;
    }
}
export {};
