/**
 * @fileoverview settings-startup-url-entry represents a UI component that
 * displays a URL that is loaded during startup. It includes a menu that allows
 * the user to edit/remove the entry.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { StartupPageInfo } from './startup_urls_page_browser_proxy.js';
/**
 * The name of the event fired from this element when the "Edit" option is
 * clicked.
 */
export declare const EDIT_STARTUP_URL_EVENT: string;
declare const SettingsStartupUrlEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/focus_row_mixin.js").FocusRowMixinInterface);
export declare class SettingsStartupUrlEntryElement extends SettingsStartupUrlEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        editable: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
        };
        model: ObjectConstructor;
    };
    editable: boolean;
    model: StartupPageInfo;
    private onRemoveClick_;
    private onEditClick_;
    private onDotsClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-startup-url-entry': SettingsStartupUrlEntryElement;
    }
}
export {};
