import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import '../settings_shared.css.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { StartupPageInfo } from './startup_urls_page_browser_proxy.js';
/**
 * Describe the current URL input error status.
 * @enum {number}
 */
declare enum UrlInputError {
    NONE = 0,
    INVALID_URL = 1,
    TOO_LONG = 2
}
/**
 * @fileoverview 'settings-startup-url-dialog' is a component for adding
 * or editing a startup URL entry.
 */
export interface SettingsStartupUrlDialogElement {
    $: {
        actionButton: CrButtonElement;
        dialog: CrDialogElement;
        url: CrInputElement;
    };
}
export declare class SettingsStartupUrlDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        error_: {
            type: NumberConstructor;
            value: UrlInputError;
        };
        url_: StringConstructor;
        urlLimit_: {
            readOnly: boolean;
            type: NumberConstructor;
            value: number;
        };
        /**
         * If specified the dialog acts as an "Edit page" dialog, otherwise as an
         * "Add new page" dialog.
         */
        model: ObjectConstructor;
        dialogTitle_: StringConstructor;
        actionButtonText_: StringConstructor;
    };
    private error_;
    private url_;
    private urlLimit_;
    model: StartupPageInfo | null;
    private dialogTitle_;
    private actionButtonText_;
    private browserProxy_;
    connectedCallback(): void;
    private hasError_;
    private errorMessage_;
    private onCancelClick_;
    private onActionButtonClick_;
    private validate_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-startup-url-dialog': SettingsStartupUrlDialogElement;
    }
}
export {};
