/**
 * @fileoverview
 * 'settings-on-startup-page' is a settings page.
 */
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/controlled_radio_button.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '../controls/settings_radio_group.js';
import '../i18n_setup.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import './startup_urls_page.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
/** Enum values for the 'session.restore_on_startup' preference. */
declare enum PrefValues {
    CONTINUE = 1,
    OPEN_NEW_TAB = 5,
    OPEN_SPECIFIC = 4,
    CONTINUE_AND_OPEN_SPECIFIC = 6
}
declare const SettingsOnStartupPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsOnStartupPageElement extends SettingsOnStartupPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        ntpExtension_: ObjectConstructor;
        prefValuesEnum_: {
            readOnly: boolean;
            type: ObjectConstructor;
            value: typeof PrefValues;
        };
    };
    prefs: Object;
    private ntpExtension_;
    connectedCallback(): void;
    private getName_;
    /**
     * Determine whether to show the user defined startup pages.
     * @param restoreOnStartup Enum value from PrefValues.
     * @return Whether the "open specific pages" or "continue and open specific
     *     pages" is selected.
     */
    private showStartupUrls_;
    /**
     * Determine whether to show "continue and open specific pages" option.
     * @param restoreOnStartup pref.
     * @return Whether the restoreOnStartup pref is recommended or enforced by
     *     policy.
     */
    private showContinueAndOpenSpecific_;
    searchContents(query: string): Promise<import("../search_settings.js").SearchResult>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-on-startup-page': SettingsOnStartupPageElement;
    }
}
export {};
