/**
 * @fileoverview 'settings-translate-page' is the settings page
 * translate settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import './add_languages_dialog.js';
import './languages.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { LanguagesModel } from './languages_types.js';
declare const SettingsTranslatePageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class SettingsTranslatePageElement extends SettingsTranslatePageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Read-only reference to the languages model provided by the
         * 'settings-languages' instance.
         */
        languages: ObjectConstructor;
        showAddAlwaysTranslateDialog_: BooleanConstructor;
        showAddNeverTranslateDialog_: BooleanConstructor;
        addLanguagesDialogLanguages_: ArrayConstructor;
    };
    languages?: LanguagesModel;
    private showAddAlwaysTranslateDialog_;
    private showAddNeverTranslateDialog_;
    private addLanguagesDialogLanguages_;
    private languageHelper_;
    private languageSettingsMetricsProxy_;
    connectedCallback(): void;
    private onTargetLanguageChange_;
    /**
     * Helper function to get the text to display in the target language drop down
     * list. Returns the display name in the current UI language and the native
     * name of the language.
     */
    private getTargetLanguageDisplayOption_;
    /**
     * Checks if a Chrome language code is equal to the translate language code.
     * Used in the translate language selector. If the item matches the translate
     * target language, it will set that item as selected.
     */
    private translateLanguageEqual_;
    /**
     * A function used for sorting languages alphabetically by display name.
     */
    private alphabeticalSort_;
    /**
     * A filter function to return true if language is not undefined and has a
     * displayName.
     */
    private hasDisplayName_;
    /**
     * Stamps and opens the Add Languages dialog, registering a listener to
     * disable the dialog's dom-if again on close.
     */
    private onAddAlwaysTranslateLanguagesClick_;
    private onAlwaysTranslateDialogClose_;
    /**
     * Helper function fired by the add dialog's on-languages-added event. Adds
     * selected languages to the always-translate languages list.
     */
    private onAlwaysTranslateLanguagesAdded_;
    /**
     * Removes a language from the always translate languages list.
     */
    private onRemoveAlwaysTranslateLanguageClick_;
    /**
     * Stamps and opens the Add Languages dialog, registering a listener to
     * disable the dialog's dom-if again on close.
     */
    private onAddNeverTranslateLanguagesClick_;
    private onNeverTranslateDialogClose_;
    private onNeverTranslateLanguagesAdded_;
    /**
     * Removes a language from the never translate languages list.
     */
    private onRemoveNeverTranslateLanguageClick_;
    private onTranslateToggleChange_;
    /**
     * @return Whether the list has any items.
     */
    private hasSome_;
    /**
     * @return Whether the list is has the given length.
     */
    private hasLength_;
    /**
     * Gets the list of languages that chrome can translate
     */
    private getTranslatableLanguages_;
    /**
     * Filters only for translate supported languages
     */
    private isTranslateSupported_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-translate-page': SettingsTranslatePageElement;
    }
}
export {};
