/**
 * @fileoverview 'settings-spell-check-page' is the settings page
 * for spell check settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/js/action_link.js';
import 'chrome://resources/cr_elements/action_link.css.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '../controls/controlled_radio_button.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { LanguagesModel } from './languages_types.js';
declare const SettingsSpellCheckPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../base_mixin.js").BaseMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSpellCheckPageElement extends SettingsSpellCheckPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Read-only reference to the languages model provided by the
         * 'settings-languages' instance.
         */
        languages: ObjectConstructor;
        hideSpellCheckLanguages_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    languages?: LanguagesModel;
    private hideSpellCheckLanguages_;
    private languageHelper_;
    private languageSettingsMetricsProxy_;
    connectedCallback(): void;
    private onSpellCheckToggleChange_;
    private onSelectedSpellingServiceChange_;
    private getSpellCheckSubLabel_;
    /**
     * Toggles the expand button within the element being listened to.
     */
    private toggleExpandButton_;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-spell-check-page': SettingsSpellCheckPageElement;
    }
}
export {};
