import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared"></style>
  <settings-section page-title="$i18n{defaultBrowser}"
      class="cr-centered-card-container">
    <template is="dom-if" if="[[maySetDefaultBrowser_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text">
          <div id="canBeDefaultBrowser">$i18n{defaultBrowser}</div>
          <div class="secondary" id="makeDefaultLabel">
            [[getMakeDefaultLabel(canPin_)]]
          </div>
        </div>
        <div class="separator"></div>
        <cr-button on-click="onSetDefaultBrowserClick_">
          $i18n{defaultBrowserMakeDefaultButton}
        </cr-button>
      </div>
    </template>
    <template is="dom-if" if="[[!maySetDefaultBrowser_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text" hidden$="[[!isDefault_]]"
            id="isDefault">
          $i18n{defaultBrowserDefault}
        </div>
        <div class="flex cr-padded-text" hidden$="[[!isSecondaryInstall_]]"
            id="isSecondaryInstall">
          $i18n{defaultBrowserSecondary}
        </div>
        <div class="cr-padded-text" hidden$="[[!isUnknownError_]]"
            id="isUnknownError">
          $i18n{defaultBrowserError}
        </div>
      </div>
    </template>
  </settings-section>
<!--_html_template_end_-->`;
}
