/**
 * @fileoverview
 * 'settings-default-browser-page' is the settings page that contains
 * settings to change the default browser (i.e. which the OS will open).
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../icons.html.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
declare const SettingsDefaultBrowserPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsDefaultBrowserPageElement extends SettingsDefaultBrowserPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        canPin_: BooleanConstructor;
        isDefault_: BooleanConstructor;
        isSecondaryInstall_: BooleanConstructor;
        isUnknownError_: BooleanConstructor;
        maySetDefaultBrowser_: BooleanConstructor;
    };
    private canPin_;
    private isDefault_;
    private isSecondaryInstall_;
    private isUnknownError_;
    private maySetDefaultBrowser_;
    private browserProxy_;
    ready(): void;
    private updateDefaultBrowserState_;
    private getMakeDefaultLabel;
    private onSetDefaultBrowserClick_;
    searchContents(query: string): Promise<import("../search_settings.js").SearchResult>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-default-browser-page': SettingsDefaultBrowserPageElement;
    }
}
export {};
