/**
 * @fileoverview 'settings-other-google-data-dialog' is a subpage
 * shown within the Clear Browsing Data dialog to provide links
 * for managing other Google data like passwords and activity.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrLinkRowElement } from 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsOtherGoogleDataDialogElement {
    $: {
        dialog: CrDialogElement;
        passwordManagerLink: CrLinkRowElement;
    };
}
declare const SettingsOtherGoogleDataDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsOtherGoogleDataDialogElement extends SettingsOtherGoogleDataDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        dialogTitle_: {
            type: StringConstructor;
            computed: string;
        };
        isGoogleDse_: {
            type: BooleanConstructor;
            value: boolean;
        };
        nonGoogleSearchHistorySubLabel_: StringConstructor;
        syncStatus_: ObjectConstructor;
    };
    private dialogTitle_;
    private isGoogleDse_;
    private nonGoogleSearchHistorySubLabel_;
    private syncStatus_;
    private clearBrowsingDataBrowserProxy_;
    private syncBrowserProxy_;
    private metricsBrowserProxy_;
    ready(): void;
    private updateDseStatus_;
    private handleSyncStatus_;
    private computeDialogTitle_;
    private onBackOrCancelClick_;
    private onPasswordManagerClick_;
    private onMyActivityLinkClick_;
    private onGoogleSearchHistoryLinkClick_;
    private onGeminiAppsActivityClick_;
    private onGeminiPersonalContextClick_;
    private shouldShowMyActivityLink_;
    private shouldShowGoogleSearchHistoryLink_;
    private shouldShowGeminiAppsActivityLink_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-other-google-data-dialog': SettingsOtherGoogleDataDialogElement;
    }
}
export {};
