/**
 * @fileoverview 'pay-over-time-issuer-list-entry' is an Pay Over Time issuer
 * row to be shown on the settings page.
 */
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../i18n_setup.js';
import '../settings_shared.css.js';
import './passwords_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare class SettingsPayOverTimeIssuerListEntryElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        payOverTimeIssuer: ObjectConstructor;
    };
    payOverTimeIssuer: chrome.autofillPrivate.PayOverTimeIssuerEntry;
    /**
     * When the provided `imageSrc` points toward an issuer's default logo art,
     * this function returns a string that will scale the image based on the
     * user's screen resolution, otherwise it will return the unmodified
     * `imageSrc`.
     */
    private getIssuerImage_;
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    private getScaledSrcSet_;
    private onRemoteEditClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-pay-over-time-issuer-list-entry': SettingsPayOverTimeIssuerListEntryElement;
    }
}
