/**
 * @fileoverview A settings subpage that allows the user to see and manage the
    passkeys on their computer.
 */
import '../settings_shared.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import '../settings_page/settings_subpage.js';
import '../site_favicon.js';
import '../simple_confirmation_dialog.js';
import './passkey_edit_dialog.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { PasskeyEditDialogElement } from './passkey_edit_dialog.js';
export interface SettingsPasskeysSubpageElement {
    $: {
        deleteErrorDialog: CrLazyRenderElement<CrDialogElement>;
        menu: CrActionMenuElement;
        editPasskeyDialog: PasskeyEditDialogElement;
    };
}
declare const SettingsPasskeysSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsPasskeysSubpageElement extends SettingsPasskeysSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** Substring to filter the passkeys by. */
        filter_: {
            type: StringConstructor;
            value: string;
        };
        passkeys_: ArrayConstructor;
        showDeleteConfirmationDialog_: BooleanConstructor;
        noManagement_: BooleanConstructor;
        showEditDialog_: BooleanConstructor;
        username_: StringConstructor;
        relyingPartyId_: StringConstructor;
    };
    private showEditDialog_;
    private username_;
    private relyingPartyId_;
    private filter_;
    private passkeys_;
    private showDeleteConfirmationDialog_;
    private noManagement_;
    private credentialIdForActionMenu_;
    private browserProxy_;
    ready(): void;
    /**
     * Used to filter the displayed passkeys when search text is entered.
     */
    private filterFunction_;
    /**
     * Called when the browser has a new list of passkeys.
     */
    private onEnumerateComplete_;
    private getIconUrl_;
    /**
     * Called when the user clicks on the three-dots icon for a passkey.
     */
    private onDotsClick_;
    /**
     * Called when the user clicks to delete a passkey.
     */
    private onDeleteClick_;
    /**
     * Called when a delete confirmation dialog is closed (whether successful or
     * not).
     */
    private onConfirmDialogClose_;
    /**
     * Called when a delete operation has completed.
     */
    private onDeleteComplete_;
    /**
     * Called when the user clicks the "ok" button on the error dialog.
     */
    private onErrorDialogOkClick_;
    /**
     * Returns the a11y label for the "More actions" button next to a passkey.
     */
    private getMoreActionsLabel_;
    private onEditClick_;
    private onEditDialogClose_;
    /**
     * Called when an edit operation has completed.
     */
    private onEditComplete_;
    /**
     * Called when the user clicks save in the passkey edit dialog.
     */
    private onSavedPasskeyEdited_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-passkeys-subpage': SettingsPasskeysSubpageElement;
    }
}
export {};
