import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared passwords-shared md-select action-link">cr-icon-button{--cr-icon-button-icon-size:16px;margin-inline-start:2px}#footnote{margin-inline-start:2px;margin-top:16px}cr-input{--cr-input-error-display:none}#websiteInput[invalid].has-error-message,#usernameInput{margin-top:var(--cr-form-field-bottom-spacing)}#usernameInput[invalid]{--cr-input-error-display:block;margin-top:var(--cr-form-field-bottom-spacing)}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title" id="title">$i18n{editPasskeyDialogTitle}</div>
  <div slot="body">
    <cr-input id="websiteInput" label="$i18n{editPasskeySiteLabel}"
        placeholder="[[relyingPartyId]]" readonly="true">
    </cr-input>
    <cr-input id="usernameInput" label="$i18n{editPasskeyUsernameLabel}"
        value="{{username}}" invalid="[[usernameInputInvalid_]]"
        error-message="[[usernameInputErrorMessage_]]">
    </cr-input>
    <div id="footnote">[[dialogFootnote_]]</div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button"
        on-click="onSaveButtonClick_" disabled="[[usernameInputInvalid_]]">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
