/**
 * @fileoverview 'settings-autofill-section' is the section containing saved
 * addresses for use in autofill and payments APIs.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '/shared/settings/prefs/prefs.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import './address_edit_dialog.js';
import './address_remove_confirmation_dialog.js';
import './passwords_shared.css.js';
import './your_saved_info_shared.css.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrToggleElement } from 'chrome://resources/cr_elements/cr_toggle/cr_toggle.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
/**
 * The enum values for the Autofill.Address.IsEnabled.Change metric.
 * These values are persisted to logs. Entries should not be renumbered and
 * numeric values should never be reused.
 */
export declare enum AutofillAddressOptInChange {
    OPT_IN = 0,
    OPT_OUT = 1,
    COUNT = 2
}
declare global {
    interface HTMLElementEventMap {
        'save-address': CustomEvent<chrome.autofillPrivate.AddressEntry>;
    }
}
export interface SettingsAutofillSectionElement {
    $: {
        autofillProfileToggle: SettingsToggleButtonElement;
        autofillSyncToggleWrapper: HTMLElement;
        autofillSyncToggle: CrToggleElement;
        addressSharedMenu: CrActionMenuElement;
        addAddress: CrButtonElement;
        addressList: HTMLElement;
        menuEditAddress: HTMLElement;
        menuRemoveAddress: HTMLElement;
        noAddressesLabel: HTMLElement;
    };
}
declare const SettingsAutofillSectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAutofillSectionElement extends SettingsAutofillSectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        accountInfo_: {
            type: ObjectConstructor;
            value: null;
        };
        /** An array of saved addresses. */
        addresses: ArrayConstructor;
        /** The model for any address related action menus or dialogs. */
        activeAddress: ObjectConstructor;
        showAddressDialog_: BooleanConstructor;
        showAddressRemoveConfirmationDialog_: BooleanConstructor;
        isGoogleProfileAddress: {
            type: BooleanConstructor;
            computed: string;
        };
        isPlusAddressEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        /**
         * Indicates if this element is used as a Your saved info subpage. Causes
         * slight adjustments like different title, no page shadow, cards being
         * visible.
         */
        isYourSavedInfoSubpage_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
    };
    prefs: {
        [key: string]: any;
    };
    addresses: chrome.autofillPrivate.AddressEntry[];
    activeAddress: chrome.autofillPrivate.AddressEntry | null;
    private accountInfo_;
    private showAddressDialog_;
    private showAddressRemoveConfirmationDialog_;
    private isGoogleProfileAddress;
    private isPlusAddressEnabled_;
    private isYourSavedInfoSubpage_;
    private autofillManager_;
    private setPersonalDataListener_;
    ready(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private getMultiCardClass_;
    private getPageTitleLabel_;
    /**
     * Returns the text for the remove button in the action menu.
     */
    private getMenuRemoveAddressLabel_;
    /**
     * Open the address action menu.
     */
    private onAddressMenuClick_;
    /**
     * Handles tapping on the "Add address" button.
     */
    private onAddAddressClick_;
    private onAddressDialogClose_;
    /**
     * Handles tapping on the "Edit" address button.
     */
    private onMenuEditAddressClick_;
    private onAddressRemoveConfirmationDialogClose_;
    /**
     * Handles tapping on the "Remove" address button.
     */
    private onMenuRemoveAddressClick_;
    /**
     * @return Whether the list exists and has items.
     */
    private hasSome_;
    /**
     * Listens for the save-address event, and calls the private API.
     */
    private saveAddress_;
    private isAccountHomeAddress_;
    private isAccountWorkAddress_;
    private isAccountNameEmailAddress_;
    private computeIsGoogleProfileAddress_;
    private onAccountHomeAddressClick_;
    private onAccountWorkAddressClick_;
    private onAccountNameEmailAddressClick_;
    private isCloudOffVisible_;
    /**
     * Determines if an icon is to be shown for the given address.
     */
    private shouldShowAddressIcon_;
    /**
     * Determines which icon to show for a given address.
     *
     * @return The icon string or an empty string.
     */
    private getAddressIcon_;
    /**
     * Determines which a11y string to announce for a given address.
     *
     * @return The a11y string or an empty string.
     */
    private getA11yLabelForIcon_;
    /**
     * @returns the title for the More Actions button corresponding to the address
     */
    private moreActionsTitle_;
    private isAutofillSyncToggleVisible_;
    private getRecordTypeSuffix_;
    private recordDeletionMetrics_;
    /**
     * Triggered by settings-toggle-button#autofillSyncToggle. It passes
     * the toggle state to the native code. If the data changed the page
     * content will be refreshed automatically via `PersonalDataChangedListener`.
     */
    private onAutofillSyncEnabledChange_;
    private onAutofillProfileToggleChanged_;
    private onPlusAddressClick_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-autofill-section': SettingsAutofillSectionElement;
    }
}
export {};
