/**
 * @fileoverview 'settings-autofill-ai-section' contains configuration options
 * for Autofill AI.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/shared/settings/prefs/prefs.js';
import '../ai_page/ai_logging_info_bullet.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../settings_columned_section.css.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../settings_shared.css.js';
import './autofill_ai_entries_list.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
export interface SettingsAutofillAiSectionElement {
    $: {
        prefToggle: SettingsToggleButtonElement;
    };
}
declare const SettingsAutofillAiSectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAutofillAiSectionElement extends SettingsAutofillAiSectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
           If a user is not eligible for Autofill with Ai, but they have data
           saved, the code allows them only to edit and delete their data. They
           are not allowed to add new data, or to opt-in or opt-out of Autofill
           with Ai using the toggle at the top of this page.
           If a user is not eligible for Autofill with Ai and they also have no
           data saved, then they cannot access this page at all.
         */
        ineligibleUser: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
           A "fake" preference object that reflects the state of the opt-in
           toggle and the presence/absence of an enterprise policy.
           This allows leveraging the settings-toggle-button component
           to reflect enterprise enabled/disabled states.
         */
        optedIn_: {
            type: ObjectConstructor;
            value: () => {
                type: chrome.settingsPrivate.PrefType;
                value: boolean;
            };
        };
        /**
          If reflects whether Wallet server data is available for storage.
        */
        isWalletServerStorageEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
          If true, Autofill AI does not depend on whether Autofill for addresses
          is enabled.
        */
        autofillAiIgnoresWhetherAddressFillingIsEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
        };
    };
    static get observers(): string[];
    ineligibleUser: boolean;
    private optedIn_;
    private isWalletServerStorageEnabled_;
    private autofillAiIgnoresWhetherAddressFillingIsEnabled_;
    private entityDataManager_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private onOptInToggleChange_;
    /**
     * Whether an info bullet regarding logging is shown. Autofill Ai only shows
     * logging behaviour information for enterprise clients who have either the
     * feature disabled or just logging disabled.
     */
    private showLoggingInfoBullet_;
    private onAutofillAddressPrefChanged_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-autofill-ai-section': SettingsAutofillAiSectionElement;
    }
}
export {};
