/**
 * @fileoverview 'settings-autofill-ai-add-or-edit-dialog' is the dialog that
 * allows adding and editing entity instances for Autofill AI.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import '../settings_shared.css.js';
import './passwords_shared.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
type EntityInstance = chrome.autofillPrivate.EntityInstance;
export interface SettingsAutofillAiAddOrEditDialogElement {
    $: {
        dialog: CrDialogElement;
    };
}
declare const SettingsAutofillAiSectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsAutofillAiAddOrEditDialogElement extends SettingsAutofillAiSectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
           The entity instance to be modified. If this is an "add" dialog, the
           entity instance has only a type, but no attribute instances or guid.
         */
        entityInstance: {
            type: ObjectConstructor;
            value: null;
        };
        dialogTitle: {
            type: StringConstructor;
            value: string;
        };
        attributeTypeDataTypeEnum_: {
            type: ObjectConstructor;
            value: typeof chrome.autofillPrivate.AttributeTypeDataType;
        };
        /**
           Complete list of attribute instances that are associated with the
           current entity instance. If this is an "edit" dialog, some attribute
           instances are populated with their already existing values.
         */
        completeAttributeInstanceList_: {
            type: ArrayConstructor;
            computed: string;
        };
        /**
           The list of all countries that should be displayed in a <select>
           element for a country field.
         */
        countryList_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
           Complete list of attribute types that are associated with the
           current entity type.
         */
        completeAttributeTypesList_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
           True if all fields are empty. The first validation occurs when the user
           clicks the "Save" button for the first time. Subsequent validations
           occur any time an input field is changed. If true, the "Save" button
           is disabled and an error message is displayed.
         */
        allFieldsAreEmpty_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
           False if the form is invalid. The first validation occurs when the user
           clicks the "Save" button for the first time. Subsequent validations
           occur any time an input field is changed. If false, the "Save" button
           is disabled and an error message is displayed.
         */
        canSave_: {
            type: BooleanConstructor;
            value: boolean;
        };
        userClickedSaveButton_: {
            type: BooleanConstructor;
            value: boolean;
        };
        months_: {
            type: ArrayConstructor;
            value: string[];
        };
        days_: {
            type: ArrayConstructor;
            value: string[];
        };
        years_: {
            type: ArrayConstructor;
            value: () => string[];
        };
    };
    entityInstance: EntityInstance | null;
    dialogTitle: string;
    private completeAttributeInstanceList_;
    private countryList_;
    private completeAttributeTypesList_;
    private allFieldsAreEmpty_;
    private canSave_;
    private userClickedSaveButton_;
    private months_;
    private days_;
    private years_;
    private entityDataManager_;
    private countryDetailManager_;
    connectedCallback(): Promise<void>;
    private computeCompleteAttributeInstanceList_;
    private convertCountryAttributeInstance_;
    private isDataType_;
    private getCountryCode_;
    private isCountrySeparator_;
    private getCountryName_;
    private getMonthName_;
    private isCountrySelected_;
    private isMonthSelected_;
    private isDaySelected_;
    private isYearSelected_;
    private onCountrySelectChange_;
    private onMonthSelectChange_;
    private onDaySelectChange_;
    private onYearSelectChange_;
    private isExistingYearOutOfBounds_;
    private getExistingYear_;
    /**
     * Returns true if the date is invalid. A date is invalid either if it is
     * incomplete (i.e. only some of the month, day, year selectors are empty), or
     * if the combination of month, day, year is invalid (i.e. 30th of February
     * 2020 is invalid).
     * Returns false if month, day, year are all empty, or if the combination of
     * month, day, year is complete and valid.
     * The first validation occurs when the user clicks the "Save" button for the
     * first time. Subsequent validations occur any time a field is changed.
     */
    private isDateInvalid_;
    /**
     * Returns true if the value is not empty and it is not made out only of
     * whitespaces.
     * For dates, at least one of month, day and year has to be not empty. An
     * incomplete date is not an empty field.
     */
    private isAttributeInstanceNotEmpty;
    private onAttributeInstanceFieldInput_;
    private validateForm_;
    private onCancelClick_;
    private onConfirmClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-autofill-ai-add-or-edit-dialog': SettingsAutofillAiAddOrEditDialogElement;
    }
}
export {};
