/**
 * @fileoverview 'address-edit-dialog' is the dialog that allows editing a saved
 * address.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/cr_textarea/cr_textarea.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsAddressEditDialogElement {
    $: {
        accountRecordTypeNotice: HTMLElement;
        cancelButton: CrButtonElement;
        country: HTMLSelectElement;
        dialog: CrDialogElement;
        saveButton: CrButtonElement;
    };
}
type AddressEntry = chrome.autofillPrivate.AddressEntry;
type AccountInfo = chrome.autofillPrivate.AccountInfo;
declare const SettingsAddressEditDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsAddressEditDialogElement extends SettingsAddressEditDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        address: ObjectConstructor;
        accountInfo: ObjectConstructor;
        title_: StringConstructor;
        validationError_: StringConstructor;
        countries_: ArrayConstructor;
        /**
         * Updates the address wrapper.
         */
        countryCode_: {
            type: StringConstructor;
            observer: string;
        };
        components_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        canSave_: BooleanConstructor;
        isAccountAddress_: {
            type: BooleanConstructor;
            computed: string;
            value: boolean;
        };
        accountAddressRecordTypeNotice_: {
            type: StringConstructor;
            computed: string;
        };
    };
    address: AddressEntry;
    accountInfo?: AccountInfo;
    /**
     * Original address is a snapshot of the address made at initialization,
     * it is a referce for soft (or "dont make it worse") validation, which
     * basically means skipping validation for fields that are already invalid.
     */
    private title_;
    private validationError_?;
    private countries_;
    private addressFields_;
    private originalAddressFields_?;
    private countryCode_;
    private components_;
    private canSave_;
    private isAccountAddress_;
    private accountAddressRecordTypeNotice_;
    private countryDetailManager_;
    connectedCallback(): void;
    private fire_;
    /**
     * Updates the wrapper that represents this address in the country's format.
     */
    private updateAddressComponents_;
    /**
     * Determines whether component with specified validation property
     * should be rendered as invalid in the template.
     */
    private isVisuallyInvalid_;
    /**
     * Makes component's potentially invalid state visible, it makes
     * the component validatable and notifies the template engine.
     * The component is addressed by row/col to leverage Polymer's notifications.
     */
    private notifyComponentValidity_;
    /**
     * Notifies all components validity (see notifyComponentValidity_()).
     */
    private notifyValidity_;
    private updateCanSave_;
    private getCode_;
    private getName_;
    private isDivision_;
    private getPhoneNumberInputClass_;
    private isAddressStoredInAccount_;
    private getAccountAddressRecordTypeNotice_;
    /**
     * Tells whether at least one address component (except country)
     * has a non empty value.
     */
    private hasAnyValue_;
    /**
     * Tells whether at least one address component (except country) is not valid.
     */
    private hasInvalidComponent_;
    /**
     * Counts how many invalid address componets (except country) are in the form.
     */
    private countInvalidComponent_;
    /**
     * Tells whether at least one address component (except country)
     * is not valid and is not validatable also, i.e. its invalid state is
     * not visible to the user.
     */
    private hasUncoveredInvalidComponent_;
    private onCancelClick_;
    /**
     * Handler for tapping the save button.
     */
    private onSaveButtonClick_;
    private onCountryCodeChanged_;
    /**
     * Syncs the country code back to the address and rebuilds the address
     * components for the new location.
     */
    private onCountryCodeSelectChange_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-address-edit-dialog': SettingsAddressEditDialogElement;
    }
}
export {};
