import 'chrome://resources/cr_components/managed_dialog/managed_dialog.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import '../controls/controlled_radio_button.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import './home_url_input.js';
import '../controls/settings_dropdown_menu.js';
import { ColorSchemeMode } from 'chrome://resources/cr_components/customize_color_scheme_mode/customize_color_scheme_mode.mojom-webui.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsDropdownMenuElement } from '../controls/settings_dropdown_menu.js';
import type { AppearancePageVisibility } from '../page_visibility.js';
/**
 * 'settings-appearance-page' is the settings page containing appearance
 * settings.
 */
export interface SettingsAppearancePageElement {
    $: {
        colorSchemeModeRow: HTMLElement;
        colorSchemeModeSelect: HTMLSelectElement;
        defaultFontSize: SettingsDropdownMenuElement;
        zoomLevel: HTMLSelectElement;
        tabSearchPositionDropdown: SettingsDropdownMenuElement;
    };
}
export declare enum SystemTheme {
    DEFAULT = 0
}
declare const SettingsAppearancePageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAppearancePageElement extends SettingsAppearancePageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Dictionary defining page visibility.
         */
        pageVisibility_: {
            type: ObjectConstructor;
            value: () => boolean | AppearancePageVisibility | undefined;
        };
        defaultZoom_: NumberConstructor;
        isWallpaperPolicyControlled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        colorSchemeModeOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value(): {
                value: ColorSchemeMode;
                name: string;
            }[];
        };
        selectedColorSchemeMode_: NumberConstructor;
        /**
         * List of options for the font size drop-down menu.
         */
        fontSizeOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value(): {
                value: number;
                name: string;
            }[];
        };
        /**
         * Predefined zoom factors to be used when zooming in/out. These are in
         * ascending order. Values are displayed in the page zoom drop-down menu
         * as percentages.
         */
        pageZoomLevels_: ArrayConstructor;
        themeSublabel_: StringConstructor;
        themeUrl_: StringConstructor;
        systemTheme_: {
            type: ObjectConstructor;
            value: SystemTheme;
        };
        isForcedTheme_: {
            type: BooleanConstructor;
            computed: string;
        };
        showHoverCardImagesOption_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        showManagedThemeDialog_: BooleanConstructor;
        sidePanelOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value(): {
                value: string;
                name: string;
            }[];
        };
        tabStripOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value(): {
                value: string;
                name: string;
            }[];
        };
        showTabSearchPositionSettings_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        showVerticalTabsEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        showTabSearchPositionRestartButton_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showSplitViewDragAndDropSetting_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        showResetPinnedActionsButton_: {
            type: BooleanConstructor;
            value: boolean;
        };
        tabSearchOptions_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value(): {
                value: string;
                name: string;
            }[];
        };
    };
    static get observers(): string[];
    private pageVisibility_?;
    private defaultZoom_;
    private isWallpaperPolicyControlled_;
    private fontSizeOptions_;
    private colorSchemeModeOptions_;
    private selectedColorSchemeMode_;
    private pageZoomLevels_;
    private themeSublabel_;
    private themeUrl_;
    private systemTheme_;
    private isForcedTheme_;
    private showHoverCardImagesOption_;
    private showResetPinnedActionsButton_;
    private showSplitViewDragAndDropSetting_;
    private showTabSearchPositionSettings_;
    private showVerticalTabsEnabled_;
    private showTabSearchPositionRestartButton_;
    private showManagedThemeDialog_;
    private sidePanelOptions_;
    private tabStripOptions_;
    private tabSearchOptions_;
    private appearanceBrowserProxy_;
    private colorSchemeModeHandler_;
    private colorSchemeModeCallbackRouter_;
    private setColorSchemeModeListenerId_;
    ready(): void;
    disconnectedCallback(): void;
    /** @return A zoom easier read by users. */
    private formatZoom_;
    /**
     * @param showHomepage Whether to show home page.
     * @param isNtp Whether to use the NTP as the home page.
     * @param homepageValue If not using NTP, use this URL.
     */
    private getShowHomeSubLabel_;
    private onCustomizeFontsClick_;
    private onDisableExtension_;
    /**
     * @param value The changed font size slider value.
     */
    private defaultFontSizeChanged_;
    private onThemeClick_;
    private onCustomizeToolbarClick_;
    private onUseDefaultClick_;
    private onResetPinnedToolbarActionsClick_;
    private themeChanged_;
    /** @return Whether applied theme is set by policy. */
    private computeIsForcedTheme_;
    private toolbarPinningStateChanged_;
    private isSelectedColorSchemeMode_;
    private onColorSchemeModeChange_;
    private onZoomLevelChange_;
    /** @see blink::ZoomValuesEqual(). */
    private zoomValuesEqual_;
    private showHr_;
    private onHoverCardImagesToggleChange_;
    private onManagedDialogClosed_;
    private onTabSearchPositionRestartClick_;
    private updateShowTabSearchRestartButton_;
    getFocusConfig(): Map<any, any>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-appearance-page': SettingsAppearancePageElement;
    }
}
export {};
