// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import './ai_logging_info_bullet.js';
import './ai_policy_indicator.js';
import '../settings_page/settings_subpage.js';
import { PrefsMixin } from '/shared/settings/prefs/prefs_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { loadTimeData } from '../i18n_setup.js';
import { AiPageTabOrganizationInteractions, MetricsBrowserProxyImpl } from '../metrics_browser_proxy.js';
import { SettingsViewMixin } from '../settings_page/settings_view_mixin.js';
import { getAiLearnMoreUrl } from './ai_learn_more_url_util.js';
import { getTemplate } from './ai_tab_organization_subpage.html.js';
import { AiEnterpriseFeaturePrefName, AiPageActions } from './constants.js';
const SettingsAiTabOrganizationSubpageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
export class SettingsAiTabOrganizationSubpageElement extends SettingsAiTabOrganizationSubpageElementBase {
    static get is() {
        return 'settings-ai-tab-organization-subpage';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            enterprisePref_: {
                type: Object,
                computed: `computePref(prefs.${AiEnterpriseFeaturePrefName.TAB_ORGANIZATION})`,
            },
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    recordInteractionMetrics_(interaction, action) {
        this.metricsBrowserProxy_.recordAiPageTabOrganizationInteractions(interaction);
        this.metricsBrowserProxy_.recordAction(action);
    }
    onLearnMoreClick_() {
        this.recordInteractionMetrics_(AiPageTabOrganizationInteractions.LEARN_MORE_LINK_CLICKED, AiPageActions.TAB_ORGANIZATION_LEARN_MORE_CLICKED);
    }
    getLearnMoreUrl_() {
        return getAiLearnMoreUrl(this.enterprisePref_, loadTimeData.getString('tabOrganizationLearnMoreUrl'), loadTimeData.getString('tabOrganizationLearnMoreManagedUrl'));
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAiTabOrganizationSubpageElement.is, SettingsAiTabOrganizationSubpageElement);
